// ************************************************************************* //
//                        CoordSwapScriptingPluginInfo.C
// ************************************************************************* //
#include <CoordSwapPluginInfo.h>
#include <PyCoordSwapAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo CoordSwap_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the CoordSwap plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new CoordSwapScriptingPluginInfo;
}

// ****************************************************************************
// Method: CoordSwapScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
CoordSwapScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyCoordSwapAttributes_StartUp((CoordSwapAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: CoordSwapScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void *
CoordSwapScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCoordSwapAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CoordSwapScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is CoordSwap plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
CoordSwapScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCoordSwapAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CoordSwapScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
CoordSwapScriptingPluginInfo::SetLogging(bool val)
{
    PyCoordSwapAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: CoordSwapScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
CoordSwapScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCoordSwapAttributes_SetDefaults((const CoordSwapAttributes *)atts);
}
