// ************************************************************************* //
//  File: CoordSwapPluginInfo.h
// ************************************************************************* //

#ifndef COORDSWAP_PLUGIN_INFO_H
#define COORDSWAP_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CoordSwapAttributes;

// ****************************************************************************
//  Class: CoordSwapPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an CoordSwap operator
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class CoordSwapGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
};

class CoordSwapCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CoordSwapGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class CoordSwapGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class CoordSwapViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static CoordSwapAttributes *defaultAtts;
    static CoordSwapAttributes *clientAtts;
};

class CoordSwapEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CoordSwapScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
