// ************************************************************************* //
//  File: CoordSwapGUIPluginInfo.C
// ************************************************************************* //

#include <CoordSwapPluginInfo.h>
#include <CoordSwapAttributes.h>
#include <QvisCoordSwapWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo CoordSwap_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the CoordSwap operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new CoordSwapGUIPluginInfo;
}

// ****************************************************************************
//  Method: CoordSwapGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

const char *
CoordSwapGUIPluginInfo::GetMenuName() const
{
    return "CoordSwap";
}


// ****************************************************************************
//  Method: CoordSwapGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

QvisPostableWindowObserver *
CoordSwapGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisCoordSwapWindow(type, (CoordSwapAttributes *)attr,
        "CoordSwap operator attributes", "CoordSwap operator", notepad);
}

// ****************************************************************************
//  Method: CoordSwapGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

#include <CoordSwap.xpm>
const char **
CoordSwapGUIPluginInfo::XPMIconData() const
{
    return CoordSwap_xpm;
}
