package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: CoordSwapAttributes
//
// Purpose:
//    This class contains attributes for the coord swap operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

public class CoordSwapAttributes extends AttributeSubject implements Plugin
{
    // Enum values
    public final static int COORD_COORD1 = 0;
    public final static int COORD_COORD2 = 1;
    public final static int COORD_COORD3 = 2;


    public CoordSwapAttributes()
    {
        super(3);

        newCoord1 = COORD_COORD1;
        newCoord2 = COORD_COORD2;
        newCoord3 = COORD_COORD3;
    }

    public CoordSwapAttributes(CoordSwapAttributes obj)
    {
        super(3);

        newCoord1 = obj.newCoord1;
        newCoord2 = obj.newCoord2;
        newCoord3 = obj.newCoord3;

        SelectAll();
    }

    public boolean equals(CoordSwapAttributes obj)
    {
        // Create the return value
        return ((newCoord1 == obj.newCoord1) &&
                (newCoord2 == obj.newCoord2) &&
                (newCoord3 == obj.newCoord3));
    }

    public String GetName() { return "CoordSwap"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetNewCoord1(int newCoord1_)
    {
        newCoord1 = newCoord1_;
        Select(0);
    }

    public void SetNewCoord2(int newCoord2_)
    {
        newCoord2 = newCoord2_;
        Select(1);
    }

    public void SetNewCoord3(int newCoord3_)
    {
        newCoord3 = newCoord3_;
        Select(2);
    }

    // Property getting methods
    public int GetNewCoord1() { return newCoord1; }
    public int GetNewCoord2() { return newCoord2; }
    public int GetNewCoord3() { return newCoord3; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(newCoord1);
        if(WriteSelect(1, buf))
            buf.WriteInt(newCoord2);
        if(WriteSelect(2, buf))
            buf.WriteInt(newCoord3);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetNewCoord1(buf.ReadInt());
                break;
            case 1:
                SetNewCoord2(buf.ReadInt());
                break;
            case 2:
                SetNewCoord3(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private int newCoord1;
    private int newCoord2;
    private int newCoord3;
}

