#include <CoordSwapAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for CoordSwapAttributes::Coord
//

static const char *Coord_strings[] = {
"Coord1", "Coord2", "Coord3"
};

std::string
CoordSwapAttributes::Coord_ToString(CoordSwapAttributes::Coord t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Coord_strings[index];
}

std::string
CoordSwapAttributes::Coord_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Coord_strings[index];
}

bool
CoordSwapAttributes::Coord_FromString(const std::string &s, CoordSwapAttributes::Coord &val)
{
    val = CoordSwapAttributes::Coord1;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Coord_strings[i])
        {
            val = (Coord)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: CoordSwapAttributes::CoordSwapAttributes
//
// Purpose: 
//   Constructor for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

CoordSwapAttributes::CoordSwapAttributes() : AttributeSubject("iii")
{
    newCoord1 = Coord1;
    newCoord2 = Coord2;
    newCoord3 = Coord3;
}

// ****************************************************************************
// Method: CoordSwapAttributes::CoordSwapAttributes
//
// Purpose: 
//   Copy constructor for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

CoordSwapAttributes::CoordSwapAttributes(const CoordSwapAttributes &obj) : AttributeSubject("iii")
{
    newCoord1 = obj.newCoord1;
    newCoord2 = obj.newCoord2;
    newCoord3 = obj.newCoord3;

    SelectAll();
}

// ****************************************************************************
// Method: CoordSwapAttributes::~CoordSwapAttributes
//
// Purpose: 
//   Destructor for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

CoordSwapAttributes::~CoordSwapAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CoordSwapAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

CoordSwapAttributes& 
CoordSwapAttributes::operator = (const CoordSwapAttributes &obj)
{
    if (this == &obj) return *this;
    newCoord1 = obj.newCoord1;
    newCoord2 = obj.newCoord2;
    newCoord3 = obj.newCoord3;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: CoordSwapAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
CoordSwapAttributes::operator == (const CoordSwapAttributes &obj) const
{
    // Create the return value
    return ((newCoord1 == obj.newCoord1) &&
            (newCoord2 == obj.newCoord2) &&
            (newCoord3 == obj.newCoord3));
}

// ****************************************************************************
// Method: CoordSwapAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
CoordSwapAttributes::operator != (const CoordSwapAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CoordSwapAttributes::TypeName
//
// Purpose: 
//   Type name method for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
CoordSwapAttributes::TypeName() const
{
    return "CoordSwapAttributes";
}

// ****************************************************************************
// Method: CoordSwapAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
CoordSwapAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const CoordSwapAttributes *tmp = (const CoordSwapAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: CoordSwapAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CoordSwapAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new CoordSwapAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: CoordSwapAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the CoordSwapAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CoordSwapAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CoordSwapAttributes(*this);
    else
        retval = new CoordSwapAttributes;

    return retval;
}

// ****************************************************************************
// Method: CoordSwapAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
CoordSwapAttributes::SelectAll()
{
    Select(0, (void *)&newCoord1);
    Select(1, (void *)&newCoord2);
    Select(2, (void *)&newCoord3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CoordSwapAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
CoordSwapAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CoordSwapAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CoordSwapAttributes.
    DataNode *node = new DataNode("CoordSwapAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("newCoord1", Coord_ToString(newCoord1)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("newCoord2", Coord_ToString(newCoord2)));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("newCoord3", Coord_ToString(newCoord3)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CoordSwapAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
CoordSwapAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CoordSwapAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("newCoord1")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetNewCoord1(Coord(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Coord value;
            if(Coord_FromString(node->AsString(), value))
                SetNewCoord1(value);
        }
    }
    if((node = searchNode->GetNode("newCoord2")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetNewCoord2(Coord(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Coord value;
            if(Coord_FromString(node->AsString(), value))
                SetNewCoord2(value);
        }
    }
    if((node = searchNode->GetNode("newCoord3")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetNewCoord3(Coord(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Coord value;
            if(Coord_FromString(node->AsString(), value))
                SetNewCoord3(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CoordSwapAttributes::SetNewCoord1(CoordSwapAttributes::Coord newCoord1_)
{
    newCoord1 = newCoord1_;
    Select(0, (void *)&newCoord1);
}

void
CoordSwapAttributes::SetNewCoord2(CoordSwapAttributes::Coord newCoord2_)
{
    newCoord2 = newCoord2_;
    Select(1, (void *)&newCoord2);
}

void
CoordSwapAttributes::SetNewCoord3(CoordSwapAttributes::Coord newCoord3_)
{
    newCoord3 = newCoord3_;
    Select(2, (void *)&newCoord3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

CoordSwapAttributes::Coord
CoordSwapAttributes::GetNewCoord1() const
{
    return Coord(newCoord1);
}

CoordSwapAttributes::Coord
CoordSwapAttributes::GetNewCoord2() const
{
    return Coord(newCoord2);
}

CoordSwapAttributes::Coord
CoordSwapAttributes::GetNewCoord3() const
{
    return Coord(newCoord3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CoordSwapAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
CoordSwapAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "New Coordinate 1?";
        case 1:  return "New Coordinate 2?";
        case 2:  return "New Coordinate 3";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CoordSwapAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
CoordSwapAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_enum;
        case 2:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CoordSwapAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
CoordSwapAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "enum";
        case 2:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CoordSwapAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
CoordSwapAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CoordSwapAttributes &obj = *((const CoordSwapAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (newCoord1 == obj.newCoord1);
        }
        break;
    case 1:
        {  // new scope
        retval = (newCoord2 == obj.newCoord2);
        }
        break;
    case 2:
        {  // new scope
        retval = (newCoord3 == obj.newCoord3);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

