#include <PyContextAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyContextAttributes
//
// Purpose: 
//   This class contains attributes for the context operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon May 6 16:03:19 PST 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a ContextAttributes.
//
struct ContextAttributesObject
{
    PyObject_HEAD
    ContextAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewContextAttributes();

static PyObject *
ContextAttributes_Notify(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_SetOffset(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the offset in the object.
    obj->data->SetOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetOffset(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOffset());
    return retval;
}

static PyObject *
ContextAttributes_SetLow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the low in the object.
    obj->data->SetLow(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetLow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLow());
    return retval;
}

static PyObject *
ContextAttributes_SetHi(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hi in the object.
    obj->data->SetHi(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetHi(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHi());
    return retval;
}

static PyObject *
ContextAttributes_SetContext(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the context in the object.
    obj->data->SetContext(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetContext(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetContext().c_str());
    return retval;
}

static PyObject *
ContextAttributes_SetCutoff(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cutoff in the object.
    obj->data->SetCutoff(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetCutoff(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCutoff());
    return retval;
}

static PyObject *
ContextAttributes_SetBelow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the below in the object.
    obj->data->SetBelow(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetBelow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetBelow());
    return retval;
}

static PyObject *
ContextAttributes_SetAbove(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the above in the object.
    obj->data->SetAbove(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContextAttributes_GetAbove(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbove());
    return retval;
}



static struct PyMethodDef ContextAttributes_methods[] = {
    {"Notify", ContextAttributes_Notify, METH_VARARGS},
    {"SetOffset", ContextAttributes_SetOffset, METH_VARARGS},
    {"GetOffset", ContextAttributes_GetOffset, METH_VARARGS},
    {"SetLow", ContextAttributes_SetLow, METH_VARARGS},
    {"GetLow", ContextAttributes_GetLow, METH_VARARGS},
    {"SetHi", ContextAttributes_SetHi, METH_VARARGS},
    {"GetHi", ContextAttributes_GetHi, METH_VARARGS},
    {"SetContext", ContextAttributes_SetContext, METH_VARARGS},
    {"GetContext", ContextAttributes_GetContext, METH_VARARGS},
    {"SetCutoff", ContextAttributes_SetCutoff, METH_VARARGS},
    {"GetCutoff", ContextAttributes_GetCutoff, METH_VARARGS},
    {"SetBelow", ContextAttributes_SetBelow, METH_VARARGS},
    {"GetBelow", ContextAttributes_GetBelow, METH_VARARGS},
    {"SetAbove", ContextAttributes_SetAbove, METH_VARARGS},
    {"GetAbove", ContextAttributes_GetAbove, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ContextAttributes_dealloc(PyObject *v)
{
   ContextAttributesObject *obj = (ContextAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ContextAttributes_compare(PyObject *v, PyObject *w)
{
    ContextAttributes *a = ((ContextAttributesObject *)v)->data;
    ContextAttributes *b = ((ContextAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ContextAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "offset") == 0)
        return ContextAttributes_GetOffset(self, NULL);
    if(strcmp(name, "low") == 0)
        return ContextAttributes_GetLow(self, NULL);
    if(strcmp(name, "hi") == 0)
        return ContextAttributes_GetHi(self, NULL);
    if(strcmp(name, "context") == 0)
        return ContextAttributes_GetContext(self, NULL);
    if(strcmp(name, "cutoff") == 0)
        return ContextAttributes_GetCutoff(self, NULL);
    if(strcmp(name, "below") == 0)
        return ContextAttributes_GetBelow(self, NULL);
    if(strcmp(name, "above") == 0)
        return ContextAttributes_GetAbove(self, NULL);

    return Py_FindMethod(ContextAttributes_methods, self, name);
}

static int
ContextAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "offset") == 0)
        retval = (ContextAttributes_SetOffset(self, tuple) != NULL);
    else if(strcmp(name, "low") == 0)
        retval = (ContextAttributes_SetLow(self, tuple) != NULL);
    else if(strcmp(name, "hi") == 0)
        retval = (ContextAttributes_SetHi(self, tuple) != NULL);
    else if(strcmp(name, "context") == 0)
        retval = (ContextAttributes_SetContext(self, tuple) != NULL);
    else if(strcmp(name, "cutoff") == 0)
        retval = (ContextAttributes_SetCutoff(self, tuple) != NULL);
    else if(strcmp(name, "below") == 0)
        retval = (ContextAttributes_SetBelow(self, tuple) != NULL);
    else if(strcmp(name, "above") == 0)
        retval = (ContextAttributes_SetAbove(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ContextAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)v;

    fprintf(fp, "offset = %g\n", obj->data->GetOffset());
    fprintf(fp, "low = %g\n", obj->data->GetLow());
    fprintf(fp, "hi = %g\n", obj->data->GetHi());
    fprintf(fp, "context = \"%s\"\n", obj->data->GetContext().c_str());
    fprintf(fp, "cutoff = %g\n", obj->data->GetCutoff());
    fprintf(fp, "below = %g\n", obj->data->GetBelow());
    fprintf(fp, "above = %g\n", obj->data->GetAbove());

    return 0;
}

//
// The doc string for the class.
//
static char *ContextAttributes_Purpose = "This class contains attributes for the context operator.";

//
// The type description structure
//
static PyTypeObject ContextAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ContextAttributes",                    // tp_name
    sizeof(ContextAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ContextAttributes_dealloc,  // tp_dealloc
    (printfunc)ContextAttributes_print,     // tp_print
    (getattrfunc)ContextAttributes_getattr, // tp_getattr
    (setattrfunc)ContextAttributes_setattr, // tp_setattr
    (cmpfunc)ContextAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ContextAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ContextAttributes *defaultAtts = 0;

static PyObject *
NewContextAttributes()
{
    ContextAttributesObject *newObject;
    newObject = PyObject_NEW(ContextAttributesObject, &ContextAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ContextAttributes(*defaultAtts);
    else
        newObject->data = new ContextAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapContextAttributes(const ContextAttributes *attr)
{
    ContextAttributesObject *newObject;
    newObject = PyObject_NEW(ContextAttributesObject, &ContextAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ContextAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ContextAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewContextAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ContextAttributesMethods[] = {
    {"ContextAttributes", ContextAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ContextAttributesObserver = 0;
static bool ContextAttributesEnableLogging = true;

static void
PyContextAttributes_WriteLog(Subject *subj, void *data)
{
    ContextAttributes *atts = (ContextAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ContextAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ContextAttributes_WriteLog()\n");
}

void
PyContextAttributes_StartUp(ContextAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyContextAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ContextAttributesObserver == 0)
    {
        ContextAttributesObserver = new ObserverToCallback(subj,
            PyContextAttributes_WriteLog, (void *)logFile);
    }

    ContextAttributesEnableLogging = true;
}

void
PyContextAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ContextAttributesObserver;
    ContextAttributesObserver = 0;
}

PyMethodDef *
PyContextAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ContextAttributesMethods;
}

bool
PyContextAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ContextAttributesType);
}

ContextAttributes *
PyContextAttributes_FromPyObject(PyObject *obj)
{
    ContextAttributesObject *obj2 = (ContextAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyContextAttributes_NewPyObject()
{
    return NewContextAttributes();
}

PyObject *
PyContextAttributes_WrapPyObject(const ContextAttributes *attr)
{
    return WrapContextAttributes(attr);
}

void
PyContextAttributes_SetLogging(bool val)
{
    ContextAttributesEnableLogging = val;
}

void
PyContextAttributes_SetDefaults(const ContextAttributes*atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ContextAttributes(*atts);
}

