// ************************************************************************* //
//  File: ContextViewerPluginInfo.C
// ************************************************************************* //

#include <ContextPluginInfo.h>
#include <ContextAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Context_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Context operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ContextViewerPluginInfo::InitializeGlobalObjects();
    return new ContextViewerPluginInfo;
}

//
// Storage for static data elements.
//
ContextAttributes *ContextViewerPluginInfo::clientAtts = NULL;
ContextAttributes *ContextViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ContextViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************
void
ContextViewerPluginInfo::InitializeGlobalObjects()
{
    ContextViewerPluginInfo::clientAtts  = new ContextAttributes;
    ContextViewerPluginInfo::defaultAtts = new ContextAttributes;
}

// ****************************************************************************
//  Method: ContextViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************

AttributeSubject *
ContextViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ContextViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************

AttributeSubject *
ContextViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ContextViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************

void
ContextViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ContextAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ContextViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************

void
ContextViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ContextAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ContextViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
// ****************************************************************************

void
ContextViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ContextAttributes*)atts = *defaultAtts;
    else
        *(ContextAttributes*)atts = *clientAtts;
}
