// ************************************************************************* //
//  File: ContextPluginInfo.h
// ************************************************************************* //

#ifndef CONTEXT_PLUGIN_INFO_H
#define CONTEXT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ContextAttributes;

// ****************************************************************************
//  Class: ContextPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Context operator
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:03 PST 2003
//
//  Modifications:
//
// ****************************************************************************

class ContextGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class ContextCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ContextGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ContextGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ContextCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
};

class ContextViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ContextCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);

    static void InitializeGlobalObjects();
  private:
    static ContextAttributes *defaultAtts;
    static ContextAttributes *clientAtts;
};

class ContextEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ContextCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ContextScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ContextCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
