// ************************************************************************* //
//  File: ContextGUIPluginInfo.C
// ************************************************************************* //

#include <ContextPluginInfo.h>
#include <ContextAttributes.h>
#include <QvisContextWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Context_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Context operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ContextGUIPluginInfo;
}

// ****************************************************************************
//  Method: ContextGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

const char *
ContextGUIPluginInfo::GetMenuName() const
{
    return "Context";
}


// ****************************************************************************
//  Method: ContextGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

QvisPostableWindowObserver *
ContextGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisContextWindow(type, (ContextAttributes *)attr,
        "Context operator attributes", "Context operator", notepad);
}
