#include <ContextAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ContextAttributes::Amount
//

static const char *Amount_strings[] = {
"Some", "All"};

std::string
ContextAttributes::Amount_ToString(ContextAttributes::Amount t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Amount_strings[index];
}

std::string
ContextAttributes::Amount_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Amount_strings[index];
}

bool
ContextAttributes::Amount_FromString(const std::string &s, ContextAttributes::Amount &val)
{
    val = ContextAttributes::Some;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Amount_strings[i])
        {
            val = (Amount)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Constructor for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::ContextAttributes() : AttributeSubject("dddsddd")
{
    offset = 2;
    low = 2;
    hi = 2;
    context = "";
    cutoff = 0;
    below = 0;
    above = 1;
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Copy constructor for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::ContextAttributes(const ContextAttributes &obj) : AttributeSubject("dddsddd")
{
    offset = obj.offset;
    low = obj.low;
    hi = obj.hi;
    context = obj.context;
    cutoff = obj.cutoff;
    below = obj.below;
    above = obj.above;

    SelectAll();
}

// ****************************************************************************
// Method: ContextAttributes::~ContextAttributes
//
// Purpose: 
//   Destructor for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::~ContextAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ContextAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ContextAttributes::operator = (const ContextAttributes &obj)
{
    offset = obj.offset;
    low = obj.low;
    hi = obj.hi;
    context = obj.context;
    cutoff = obj.cutoff;
    below = obj.below;
    above = obj.above;

    SelectAll();
}

// ****************************************************************************
// Method: ContextAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::operator == (const ContextAttributes &obj) const
{
    // Create the return value
    return ((offset == obj.offset) &&
            (low == obj.low) &&
            (hi == obj.hi) &&
            (context == obj.context) &&
            (cutoff == obj.cutoff) &&
            (below == obj.below) &&
            (above == obj.above));
}

// ****************************************************************************
// Method: ContextAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::operator != (const ContextAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ContextAttributes::TypeName
//
// Purpose: 
//   Type name method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ContextAttributes::TypeName() const
{
    return "ContextAttributes";
}

// ****************************************************************************
// Method: ContextAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ContextAttributes *tmp = (const ContextAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ContextAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ContextAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ContextAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ContextAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ContextAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ContextAttributes(*this);
    else
        retval = new ContextAttributes;

    return retval;
}

// ****************************************************************************
// Method: ContextAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ContextAttributes::SelectAll()
{
    Select(0, (void *)&offset);
    Select(1, (void *)&low);
    Select(2, (void *)&hi);
    Select(3, (void *)&context);
    Select(4, (void *)&cutoff);
    Select(5, (void *)&below);
    Select(6, (void *)&above);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ContextAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ContextAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ContextAttributes.
    DataNode *node = new DataNode("ContextAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("offset", offset));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("low", low));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hi", hi));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("context", context));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cutoff", cutoff));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("below", below));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("above", above));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ContextAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ContextAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ContextAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("offset")) != 0)
        SetOffset(node->AsDouble());
    if((node = searchNode->GetNode("low")) != 0)
        SetLow(node->AsDouble());
    if((node = searchNode->GetNode("hi")) != 0)
        SetHi(node->AsDouble());
    if((node = searchNode->GetNode("context")) != 0)
        SetContext(node->AsString());
    if((node = searchNode->GetNode("cutoff")) != 0)
        SetCutoff(node->AsDouble());
    if((node = searchNode->GetNode("below")) != 0)
        SetBelow(node->AsDouble());
    if((node = searchNode->GetNode("above")) != 0)
        SetAbove(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ContextAttributes::SetOffset(double offset_)
{
    offset = offset_;
    Select(0, (void *)&offset);
}

void
ContextAttributes::SetLow(double low_)
{
    low = low_;
    Select(1, (void *)&low);
}

void
ContextAttributes::SetHi(double hi_)
{
    hi = hi_;
    Select(2, (void *)&hi);
}

void
ContextAttributes::SetContext(const std::string &context_)
{
    context = context_;
    Select(3, (void *)&context);
}

void
ContextAttributes::SetCutoff(double cutoff_)
{
    cutoff = cutoff_;
    Select(4, (void *)&cutoff);
}

void
ContextAttributes::SetBelow(double below_)
{
    below = below_;
    Select(5, (void *)&below);
}

void
ContextAttributes::SetAbove(double above_)
{
    above = above_;
    Select(6, (void *)&above);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
ContextAttributes::GetOffset() const
{
    return offset;
}

double
ContextAttributes::GetLow() const
{
    return low;
}

double
ContextAttributes::GetHi() const
{
    return hi;
}

const std::string &
ContextAttributes::GetContext() const
{
    return context;
}

std::string &
ContextAttributes::GetContext()
{
    return context;
}

double
ContextAttributes::GetCutoff() const
{
    return cutoff;
}

double
ContextAttributes::GetBelow() const
{
    return below;
}

double
ContextAttributes::GetAbove() const
{
    return above;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ContextAttributes::SelectContext()
{
    Select(3, (void *)&context);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ContextAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ContextAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Offset the primary variable by ";
        case 1:  return "Use the primary variable if it is above ";
        case 2:  return "Use the primary variable if it is below ";
        case 3:  return "Context Variable";
        case 4:  return "Cutoff for context variable";
        case 5:  return "Map values below the cutoff to ";
        case 6:  return "Map values above the cutoff to ";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ContextAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ContextAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_double;
        case 1:  return FieldType_double;
        case 2:  return FieldType_double;
        case 3:  return FieldType_string;
        case 4:  return FieldType_double;
        case 5:  return FieldType_double;
        case 6:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ContextAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ContextAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "double";
        case 1:  return "double";
        case 2:  return "double";
        case 3:  return "string";
        case 4:  return "double";
        case 5:  return "double";
        case 6:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ContextAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:32 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ContextAttributes &obj = *((const ContextAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (offset == obj.offset);
        }
        break;
    case 1:
        {  // new scope
        retval = (low == obj.low);
        }
        break;
    case 2:
        {  // new scope
        retval = (hi == obj.hi);
        }
        break;
    case 3:
        {  // new scope
        retval = (context == obj.context);
        }
        break;
    case 4:
        {  // new scope
        retval = (cutoff == obj.cutoff);
        }
        break;
    case 5:
        {  // new scope
        retval = (below == obj.below);
        }
        break;
    case 6:
        {  // new scope
        retval = (above == obj.above);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

