// ************************************************************************* //
//  File: avtConnCompReduceFilter.h
// ************************************************************************* //

#ifndef AVT_ConnCompReduce_FILTER_H
#define AVT_ConnCompReduce_FILTER_H


#include <avtPluginStreamer.h>
#include <ConnCompReduceAttributes.h>

class vtkDataSet;
class vtkPolyData;
class vtkUnstructuredGrid;


// ****************************************************************************
//  Class: avtConnCompReduceFilter
//
//  Purpose:
//      A plugin operator for ConnCompReduce.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 29 10:16:45 PDT 2002
//
// ****************************************************************************

class avtConnCompReduceFilter : public avtPluginStreamer
{
  public:
                         avtConnCompReduceFilter();
    virtual             ~avtConnCompReduceFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtConnCompReduceFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Reduce Connected Components"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    ConnCompReduceAttributes   atts;
    bool                       haveIssuedWarning;

    virtual vtkDataSet   *ExecuteData(vtkDataSet *, int, std::string);
    virtual void          PreExecute(void);

    vtkDataSet           *PolyDataExecute(vtkPolyData *);
    vtkDataSet           *UnstructuredGridExecute(vtkUnstructuredGrid *);
    void                  MakeComponentList(double, int, bool *);
    int                   DetermineConnectedComponents(vtkDataSet *, int *);
};


#endif
