#include <PyConnCompReduceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyConnCompReduceAttributes
//
// Purpose: 
//   This class contains attributes for the reduce connected components operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Oct 29 10:16:45 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConnCompReduceAttributes.
//
struct ConnCompReduceAttributesObject
{
    PyObject_HEAD
    ConnCompReduceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewConnCompReduceAttributes();

static PyObject *
ConnCompReduceAttributes_Notify(PyObject *self, PyObject *args)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConnCompReduceAttributes_SetTarget(PyObject *self, PyObject *args)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the target in the object.
    obj->data->SetTarget(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConnCompReduceAttributes_GetTarget(PyObject *self, PyObject *args)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTarget());
    return retval;
}



static struct PyMethodDef ConnCompReduceAttributes_methods[] = {
    {"Notify", ConnCompReduceAttributes_Notify, METH_VARARGS},
    {"SetTarget", ConnCompReduceAttributes_SetTarget, METH_VARARGS},
    {"GetTarget", ConnCompReduceAttributes_GetTarget, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConnCompReduceAttributes_dealloc(PyObject *v)
{
   ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ConnCompReduceAttributes_compare(PyObject *v, PyObject *w)
{
    ConnCompReduceAttributes *a = ((ConnCompReduceAttributesObject *)v)->data;
    ConnCompReduceAttributes *b = ((ConnCompReduceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ConnCompReduceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "target") == 0)
        return ConnCompReduceAttributes_GetTarget(self, NULL);

    return Py_FindMethod(ConnCompReduceAttributes_methods, self, name);
}

static int
ConnCompReduceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "target") == 0)
        retval = (ConnCompReduceAttributes_SetTarget(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ConnCompReduceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)v;

    fprintf(fp, "target = %g\n", obj->data->GetTarget());

    return 0;
}

//
// The doc string for the class.
//
static char *ConnCompReduceAttributes_Purpose = "This class contains attributes for the reduce connected components operator.";

//
// The type description structure
//
static PyTypeObject ConnCompReduceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConnCompReduceAttributes",                    // tp_name
    sizeof(ConnCompReduceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConnCompReduceAttributes_dealloc,  // tp_dealloc
    (printfunc)ConnCompReduceAttributes_print,     // tp_print
    (getattrfunc)ConnCompReduceAttributes_getattr, // tp_getattr
    (setattrfunc)ConnCompReduceAttributes_setattr, // tp_setattr
    (cmpfunc)ConnCompReduceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConnCompReduceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConnCompReduceAttributes *defaultAtts = 0;

static PyObject *
NewConnCompReduceAttributes()
{
    ConnCompReduceAttributesObject *newObject;
    newObject = PyObject_NEW(ConnCompReduceAttributesObject, &ConnCompReduceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ConnCompReduceAttributes(*defaultAtts);
    else
        newObject->data = new ConnCompReduceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapConnCompReduceAttributes(const ConnCompReduceAttributes *attr)
{
    ConnCompReduceAttributesObject *newObject;
    newObject = PyObject_NEW(ConnCompReduceAttributesObject, &ConnCompReduceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConnCompReduceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConnCompReduceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewConnCompReduceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConnCompReduceAttributesMethods[] = {
    {"ConnCompReduceAttributes", ConnCompReduceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConnCompReduceAttributesObserver = 0;
static bool ConnCompReduceAttributesEnableLogging = true;

static void
PyConnCompReduceAttributes_WriteLog(Subject *subj, void *data)
{
    ConnCompReduceAttributes *atts = (ConnCompReduceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ConnCompReduceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ConnCompReduceAttributes_WriteLog()\n");
}

void
PyConnCompReduceAttributes_StartUp(ConnCompReduceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyConnCompReduceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConnCompReduceAttributesObserver == 0)
    {
        ConnCompReduceAttributesObserver = new ObserverToCallback(subj,
            PyConnCompReduceAttributes_WriteLog, (void *)logFile);
    }

    ConnCompReduceAttributesEnableLogging = true;
}

void
PyConnCompReduceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConnCompReduceAttributesObserver;
    ConnCompReduceAttributesObserver = 0;
}

PyMethodDef *
PyConnCompReduceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConnCompReduceAttributesMethods;
}

bool
PyConnCompReduceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConnCompReduceAttributesType);
}

ConnCompReduceAttributes *
PyConnCompReduceAttributes_FromPyObject(PyObject *obj)
{
    ConnCompReduceAttributesObject *obj2 = (ConnCompReduceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConnCompReduceAttributes_NewPyObject()
{
    return NewConnCompReduceAttributes();
}

PyObject *
PyConnCompReduceAttributes_WrapPyObject(const ConnCompReduceAttributes *attr)
{
    return WrapConnCompReduceAttributes(attr);
}

void
PyConnCompReduceAttributes_SetLogging(bool val)
{
    ConnCompReduceAttributesEnableLogging = val;
}

void
PyConnCompReduceAttributes_SetDefaults(const ConnCompReduceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConnCompReduceAttributes(*atts);
}

