// ************************************************************************* //
//  File: ConnCompReduceViewerPluginInfo.C
// ************************************************************************* //

#include <ConnCompReducePluginInfo.h>
#include <ConnCompReduceAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo ConnCompReduce_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the ConnCompReduce operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ConnCompReduceViewerPluginInfo::InitializeGlobalObjects();
    return new ConnCompReduceViewerPluginInfo;
}

//
// Storage for static data elements.
//
ConnCompReduceAttributes *ConnCompReduceViewerPluginInfo::clientAtts = NULL;
ConnCompReduceAttributes *ConnCompReduceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ConnCompReduceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************
void
ConnCompReduceViewerPluginInfo::InitializeGlobalObjects()
{
    ConnCompReduceViewerPluginInfo::clientAtts  = new ConnCompReduceAttributes;
    ConnCompReduceViewerPluginInfo::defaultAtts = new ConnCompReduceAttributes;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************

AttributeSubject *
ConnCompReduceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************

AttributeSubject *
ConnCompReduceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************

void
ConnCompReduceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ConnCompReduceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ConnCompReduceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************

void
ConnCompReduceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ConnCompReduceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:46 PST 2003
//
// ****************************************************************************

void
ConnCompReduceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ConnCompReduceAttributes*)atts = *defaultAtts;
    else
        *(ConnCompReduceAttributes*)atts = *clientAtts;
}
