// ************************************************************************* //
//  File: ConnCompReduceGUIPluginInfo.C
// ************************************************************************* //

#include <ConnCompReducePluginInfo.h>
#include <ConnCompReduceAttributes.h>
#include <QvisConnCompReduceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo ConnCompReduce_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the ConnCompReduce operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 29 10:16:44 PDT 2002
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ConnCompReduceGUIPluginInfo;
}

// ****************************************************************************
//  Method: ConnCompReduceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 29 10:16:44 PDT 2002
//
// ****************************************************************************

const char *
ConnCompReduceGUIPluginInfo::GetMenuName() const
{
    return "Reduce Connected Components";
}


// ****************************************************************************
//  Method: ConnCompReduceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 29 10:16:44 PDT 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
ConnCompReduceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisConnCompReduceWindow(type, (ConnCompReduceAttributes *)attr,
        "Reduce Connected Components operator attributes", "ConnCompReduce operator", notepad);
}
