package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: ConnCompReduceAttributes
//
// Purpose:
//    This class contains attributes for the reduce connected components operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:09:05 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class ConnCompReduceAttributes extends AttributeSubject implements Plugin
{
    public ConnCompReduceAttributes()
    {
        super(1);

        target = 0.1;
    }

    public ConnCompReduceAttributes(ConnCompReduceAttributes obj)
    {
        super(1);

        target = obj.target;

        SelectAll();
    }

    public boolean equals(ConnCompReduceAttributes obj)
    {
        // Create the return value
        return ((target == obj.target));
    }

    public String GetName() { return "ConnCompReduce"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetTarget(double target_)
    {
        target = target_;
        Select(0);
    }

    // Property getting methods
    public double GetTarget() { return target; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(target);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        SetTarget(buf.ReadDouble());
    }


    // Attributes
    private double target;
}

