// ************************************************************************* //
//  File: avtConeFilter.h
// ************************************************************************* //

#ifndef AVT_Cone_FILTER_H
#define AVT_Cone_FILTER_H


#include <avtPluginStreamer.h>
#include <ConeAttributes.h>


class vtkClipPolyData;
class vtkCone;
class vtkCutter;
class vtkDataSet;
class vtkImplicitBoolean;
class vtkPlane;
class vtkTransformPolyDataFilter;

class vtkPolarTransformFilter;


// ****************************************************************************
//  Class: avtConeFilter
//
//  Purpose:
//      A plugin operator for Cone.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed May 29 16:09:58 PST 2002
//
//  Modifications:
//    Kathleen Bonnell, Tue May 20 10:23:38 PDT 2003
//    Added method PerformRestriction.
//
// ****************************************************************************

class avtConeFilter : public avtPluginStreamer
{
  public:
                                 avtConeFilter();
    virtual                     ~avtConeFilter();

    static avtFilter            *Create();

    virtual const char          *GetType(void)  { return "avtConeFilter"; };
    virtual const char          *GetDescription(void) 
                                             { return "Slicing by a cone"; };
    virtual void                 ReleaseData(void);

    virtual void                 SetAtts(const AttributeGroup*);
    virtual bool                 Equivalent(const AttributeGroup*);

  protected:
    ConeAttributes               atts;
    vtkCone                     *cone;
    vtkCutter                   *cutter;
    vtkImplicitBoolean          *allFunctions;
    vtkPlane                    *plane;
    vtkPolarTransformFilter     *polar;
    vtkTransformPolyDataFilter  *transform;
    vtkClipPolyData             *clipOffSides;
    vtkClipPolyData             *clipBottom;
    vtkPlane                    *planeToClipBottom;
    vtkClipPolyData             *clipByLength;
    vtkPlane                    *planeToClipByLength;

    virtual vtkDataSet          *ExecuteData(vtkDataSet *, int, std::string);
    virtual void                 RefashionDataObjectInfo(void);
    void                         SetUpClipping(void);
    void                         SetUpCone(void);
    void                         SetUpProjection(void);
    avtPipelineSpecification_p   PerformRestriction(avtPipelineSpecification_p);
};


#endif
