#include <PyConeAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyConeAttributes
//
// Purpose: 
//   This class contains attributes for the cone operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Jun 3 15:59:58 PST 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConeAttributes.
//
struct ConeAttributesObject
{
    PyObject_HEAD
    ConeAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewConeAttributes();

static PyObject *
ConeAttributes_Notify(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_SetAngle(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the angle in the object.
    obj->data->SetAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetAngle(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAngle());
    return retval;
}

static PyObject *
ConeAttributes_SetOrigin(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double *dvals = obj->data->GetOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the origin in the object as modified.
    obj->data->SelectOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetOrigin(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the origin.
    PyObject *retval = PyTuple_New(3);
    const double *origin = obj->data->GetOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(origin[i]));
    return retval;
}

static PyObject *
ConeAttributes_SetNormal(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double *dvals = obj->data->GetNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the normal in the object as modified.
    obj->data->SelectNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetNormal(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the normal.
    PyObject *retval = PyTuple_New(3);
    const double *normal = obj->data->GetNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(normal[i]));
    return retval;
}

static PyObject *
ConeAttributes_SetRepresentation(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the representation in the object.
    obj->data->SetRepresentation(ConeAttributes::Representation(ival));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetRepresentation(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRepresentation()));
    return retval;
}

static PyObject *
ConeAttributes_SetUpAxis(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double *dvals = obj->data->GetUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the upAxis in the object as modified.
    obj->data->SelectUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetUpAxis(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the upAxis.
    PyObject *retval = PyTuple_New(3);
    const double *upAxis = obj->data->GetUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(upAxis[i]));
    return retval;
}

static PyObject *
ConeAttributes_SetCutByLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cutByLength in the object.
    obj->data->SetCutByLength(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetCutByLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCutByLength()?1L:0L);
    return retval;
}

static PyObject *
ConeAttributes_SetLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the length in the object.
    obj->data->SetLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ConeAttributes_GetLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLength());
    return retval;
}



static struct PyMethodDef ConeAttributes_methods[] = {
    {"Notify", ConeAttributes_Notify, METH_VARARGS},
    {"SetAngle", ConeAttributes_SetAngle, METH_VARARGS},
    {"GetAngle", ConeAttributes_GetAngle, METH_VARARGS},
    {"SetOrigin", ConeAttributes_SetOrigin, METH_VARARGS},
    {"GetOrigin", ConeAttributes_GetOrigin, METH_VARARGS},
    {"SetNormal", ConeAttributes_SetNormal, METH_VARARGS},
    {"GetNormal", ConeAttributes_GetNormal, METH_VARARGS},
    {"SetRepresentation", ConeAttributes_SetRepresentation, METH_VARARGS},
    {"GetRepresentation", ConeAttributes_GetRepresentation, METH_VARARGS},
    {"SetUpAxis", ConeAttributes_SetUpAxis, METH_VARARGS},
    {"GetUpAxis", ConeAttributes_GetUpAxis, METH_VARARGS},
    {"SetCutByLength", ConeAttributes_SetCutByLength, METH_VARARGS},
    {"GetCutByLength", ConeAttributes_GetCutByLength, METH_VARARGS},
    {"SetLength", ConeAttributes_SetLength, METH_VARARGS},
    {"GetLength", ConeAttributes_GetLength, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConeAttributes_dealloc(PyObject *v)
{
   ConeAttributesObject *obj = (ConeAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ConeAttributes_compare(PyObject *v, PyObject *w)
{
    ConeAttributes *a = ((ConeAttributesObject *)v)->data;
    ConeAttributes *b = ((ConeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ConeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "angle") == 0)
        return ConeAttributes_GetAngle(self, NULL);
    if(strcmp(name, "origin") == 0)
        return ConeAttributes_GetOrigin(self, NULL);
    if(strcmp(name, "normal") == 0)
        return ConeAttributes_GetNormal(self, NULL);
    if(strcmp(name, "representation") == 0)
        return ConeAttributes_GetRepresentation(self, NULL);
    if(strcmp(name, "ThreeD") == 0)
        return PyInt_FromLong(long(ConeAttributes::ThreeD));
    else if(strcmp(name, "Flattened") == 0)
        return PyInt_FromLong(long(ConeAttributes::Flattened));
    else if(strcmp(name, "R_Theta") == 0)
        return PyInt_FromLong(long(ConeAttributes::R_Theta));

    if(strcmp(name, "upAxis") == 0)
        return ConeAttributes_GetUpAxis(self, NULL);
    if(strcmp(name, "cutByLength") == 0)
        return ConeAttributes_GetCutByLength(self, NULL);
    if(strcmp(name, "length") == 0)
        return ConeAttributes_GetLength(self, NULL);

    return Py_FindMethod(ConeAttributes_methods, self, name);
}

static int
ConeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "angle") == 0)
        retval = (ConeAttributes_SetAngle(self, tuple) != NULL);
    else if(strcmp(name, "origin") == 0)
        retval = (ConeAttributes_SetOrigin(self, tuple) != NULL);
    else if(strcmp(name, "normal") == 0)
        retval = (ConeAttributes_SetNormal(self, tuple) != NULL);
    else if(strcmp(name, "representation") == 0)
        retval = (ConeAttributes_SetRepresentation(self, tuple) != NULL);
    else if(strcmp(name, "upAxis") == 0)
        retval = (ConeAttributes_SetUpAxis(self, tuple) != NULL);
    else if(strcmp(name, "cutByLength") == 0)
        retval = (ConeAttributes_SetCutByLength(self, tuple) != NULL);
    else if(strcmp(name, "length") == 0)
        retval = (ConeAttributes_SetLength(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ConeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)v;

    fprintf(fp, "angle = %g\n", obj->data->GetAngle());
    {   const double *origin = obj->data->GetOrigin();
        fprintf(fp, "origin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", origin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *normal = obj->data->GetNormal();
        fprintf(fp, "normal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", normal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetRepresentation() == ConeAttributes::ThreeD)
        fprintf(fp, "representation = ThreeD\n");
    else if(obj->data->GetRepresentation() == ConeAttributes::Flattened)
        fprintf(fp, "representation = Flattened\n");
    else
        fprintf(fp, "representation = R_Theta\n");

    {   const double *upAxis = obj->data->GetUpAxis();
        fprintf(fp, "upAxis = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", upAxis[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetCutByLength())
        fprintf(fp, "cutByLength = 1\n");
    else
        fprintf(fp, "cutByLength = 0\n");
    fprintf(fp, "length = %g\n", obj->data->GetLength());

    return 0;
}

//
// The doc string for the class.
//
static char *ConeAttributes_Purpose = "This class contains attributes for the cone operator.";

//
// The type description structure
//
static PyTypeObject ConeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConeAttributes",                    // tp_name
    sizeof(ConeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConeAttributes_dealloc,  // tp_dealloc
    (printfunc)ConeAttributes_print,     // tp_print
    (getattrfunc)ConeAttributes_getattr, // tp_getattr
    (setattrfunc)ConeAttributes_setattr, // tp_setattr
    (cmpfunc)ConeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConeAttributes *defaultAtts = 0;

static PyObject *
NewConeAttributes()
{
    ConeAttributesObject *newObject;
    newObject = PyObject_NEW(ConeAttributesObject, &ConeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ConeAttributes(*defaultAtts);
    else
        newObject->data = new ConeAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapConeAttributes(const ConeAttributes *attr)
{
    ConeAttributesObject *newObject;
    newObject = PyObject_NEW(ConeAttributesObject, &ConeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConeAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConeAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewConeAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConeAttributesMethods[] = {
    {"ConeAttributes", ConeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConeAttributesObserver = 0;
static bool ConeAttributesEnableLogging = true;

static void
PyConeAttributes_WriteLog(Subject *subj, void *data)
{
    ConeAttributes *atts = (ConeAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ConeAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ConeAttributes_WriteLog()\n");
}

void
PyConeAttributes_StartUp(ConeAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyConeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConeAttributesObserver == 0)
    {
        ConeAttributesObserver = new ObserverToCallback(subj,
            PyConeAttributes_WriteLog, (void *)logFile);
    }

    ConeAttributesEnableLogging = true;
}

void
PyConeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConeAttributesObserver;
    ConeAttributesObserver = 0;
}

PyMethodDef *
PyConeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConeAttributesMethods;
}

bool
PyConeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConeAttributesType);
}

ConeAttributes *
PyConeAttributes_FromPyObject(PyObject *obj)
{
    ConeAttributesObject *obj2 = (ConeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConeAttributes_NewPyObject()
{
    return NewConeAttributes();
}

PyObject *
PyConeAttributes_WrapPyObject(const ConeAttributes *attr)
{
    return WrapConeAttributes(attr);
}

void
PyConeAttributes_SetLogging(bool val)
{
    ConeAttributesEnableLogging = val;
}

void
PyConeAttributes_SetDefaults(const ConeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConeAttributes(*atts);
}

