// ************************************************************************* //
//  File: ConeViewerPluginInfo.C
// ************************************************************************* //

#include <ConePluginInfo.h>
#include <ConeAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Cone_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Cone operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ConeViewerPluginInfo::InitializeGlobalObjects();
    return new ConeViewerPluginInfo;
}

//
// Storage for static data elements.
//
ConeAttributes *ConeViewerPluginInfo::clientAtts = NULL;
ConeAttributes *ConeViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ConeViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************
void
ConeViewerPluginInfo::InitializeGlobalObjects()
{
    ConeViewerPluginInfo::clientAtts  = new ConeAttributes;
    ConeViewerPluginInfo::defaultAtts = new ConeAttributes;
}

// ****************************************************************************
//  Method: ConeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************

AttributeSubject *
ConeViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ConeViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************

AttributeSubject *
ConeViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ConeViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************

void
ConeViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ConeAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ConeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************

void
ConeViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ConeAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ConeViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************

void
ConeViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ConeAttributes*)atts = *defaultAtts;
    else
        *(ConeAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ConeViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
// ****************************************************************************

#include <Cone.xpm>
const char **
ConeViewerPluginInfo::XPMIconData() const
{
    return Cone_xpm;
}
