// ************************************************************************* //
//                        ConeScriptingPluginInfo.C
// ************************************************************************* //
#include <ConePluginInfo.h>
#include <PyConeAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Cone_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Cone plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 3 15:59:57 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ConeScriptingPluginInfo;
}

// ****************************************************************************
// Method: ConeScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 3 15:59:57 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ConeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyConeAttributes_StartUp((ConeAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ConeScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 3 15:59:57 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
ConeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyConeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ConeScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Cone plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 3 15:59:57 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
ConeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyConeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ConeScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 3 15:59:57 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ConeScriptingPluginInfo::SetLogging(bool val)
{
    PyConeAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ConeScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 3 15:59:57 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ConeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyConeAttributes_SetDefaults((const ConeAttributes *)atts);
}
