// ************************************************************************* //
//  File: ConePluginInfo.h
// ************************************************************************* //

#ifndef CONE_PLUGIN_INFO_H
#define CONE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ConeAttributes;

// ****************************************************************************
//  Class: ConePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Cone operator
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:28 PST 2003
//
//  Modifications:
//
// ****************************************************************************

class ConeGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class ConeCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ConeGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ConeGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ConeCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ConeViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ConeCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static ConeAttributes *defaultAtts;
    static ConeAttributes *clientAtts;
};

class ConeEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ConeCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ConeScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ConeCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
