// ************************************************************************* //
//  File: ConeGUIPluginInfo.C
// ************************************************************************* //

#include <ConePluginInfo.h>
#include <ConeAttributes.h>
#include <QvisConeWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Cone_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Cone operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:21:02 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ConeGUIPluginInfo;
}

// ****************************************************************************
//  Method: ConeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:21:02 PST 2003
//
// ****************************************************************************

const char *
ConeGUIPluginInfo::GetMenuName() const
{
    return "Cone";
}


// ****************************************************************************
//  Method: ConeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:21:02 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
ConeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisConeWindow(type, (ConeAttributes *)attr,
        "Cone operator attributes", "Cone operator", notepad);
}

// ****************************************************************************
//  Method: ConeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:21:02 PST 2003
//
// ****************************************************************************

#include <Cone.xpm>
const char **
ConeGUIPluginInfo::XPMIconData() const
{
    return Cone_xpm;
}
