#ifndef CONEATTRIBUTES_H
#define CONEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: ConeAttributes
//
// Purpose:
//    This class contains attributes for the cone operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:26 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class ConeAttributes : public AttributeSubject
{
public:
    enum Representation
    {
        ThreeD,
        Flattened,
        R_Theta
    };

    ConeAttributes();
    ConeAttributes(const ConeAttributes &obj);
    virtual ~ConeAttributes();

    virtual void operator = (const ConeAttributes &obj);
    virtual bool operator == (const ConeAttributes &obj) const;
    virtual bool operator != (const ConeAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectOrigin();
    void SelectNormal();
    void SelectUpAxis();

    // Property setting methods
    void SetAngle(double angle_);
    void SetOrigin(const double *origin_);
    void SetNormal(const double *normal_);
    void SetRepresentation(Representation representation_);
    void SetUpAxis(const double *upAxis_);
    void SetCutByLength(bool cutByLength_);
    void SetLength(double length_);

    // Property getting methods
    double       GetAngle() const;
    const double *GetOrigin() const;
          double *GetOrigin();
    const double *GetNormal() const;
          double *GetNormal();
    Representation GetRepresentation() const;
    const double *GetUpAxis() const;
          double *GetUpAxis();
    bool         GetCutByLength() const;
    double       GetLength() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Representation_ToString(Representation);
    static bool Representation_FromString(const std::string &, Representation &);
protected:
    static std::string Representation_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    double angle;
    double origin[3];
    double normal[3];
    int    representation;
    double upAxis[3];
    bool   cutByLength;
    double length;
};

#endif
