#include <ConeAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ConeAttributes::Representation
//

static const char *Representation_strings[] = {
"ThreeD", "Flattened", "R_Theta"
};

std::string
ConeAttributes::Representation_ToString(ConeAttributes::Representation t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Representation_strings[index];
}

std::string
ConeAttributes::Representation_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Representation_strings[index];
}

bool
ConeAttributes::Representation_FromString(const std::string &s, ConeAttributes::Representation &val)
{
    val = ConeAttributes::ThreeD;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Representation_strings[i])
        {
            val = (Representation)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ConeAttributes::ConeAttributes
//
// Purpose: 
//   Constructor for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ConeAttributes::ConeAttributes() : AttributeSubject("dDDiDbd")
{
    angle = 45;
    origin[0] = 0;
    origin[1] = 0;
    origin[2] = 0;
    normal[0] = 0;
    normal[1] = 0;
    normal[2] = 1;
    representation = Flattened;
    upAxis[0] = 0;
    upAxis[1] = 1;
    upAxis[2] = 0;
    cutByLength = false;
    length = 1;
}

// ****************************************************************************
// Method: ConeAttributes::ConeAttributes
//
// Purpose: 
//   Copy constructor for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ConeAttributes::ConeAttributes(const ConeAttributes &obj) : AttributeSubject("dDDiDbd")
{
    angle = obj.angle;
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    normal[0] = obj.normal[0];
    normal[1] = obj.normal[1];
    normal[2] = obj.normal[2];

    representation = obj.representation;
    upAxis[0] = obj.upAxis[0];
    upAxis[1] = obj.upAxis[1];
    upAxis[2] = obj.upAxis[2];

    cutByLength = obj.cutByLength;
    length = obj.length;

    SelectAll();
}

// ****************************************************************************
// Method: ConeAttributes::~ConeAttributes
//
// Purpose: 
//   Destructor for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ConeAttributes::~ConeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ConeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ConeAttributes::operator = (const ConeAttributes &obj)
{
    angle = obj.angle;
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    normal[0] = obj.normal[0];
    normal[1] = obj.normal[1];
    normal[2] = obj.normal[2];

    representation = obj.representation;
    upAxis[0] = obj.upAxis[0];
    upAxis[1] = obj.upAxis[1];
    upAxis[2] = obj.upAxis[2];

    cutByLength = obj.cutByLength;
    length = obj.length;

    SelectAll();
}

// ****************************************************************************
// Method: ConeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ConeAttributes::operator == (const ConeAttributes &obj) const
{
    int i;

    // Compare the origin arrays.
    bool origin_equal = true;
    for(i = 0; i < 3 && origin_equal; ++i)
        origin_equal = (origin[i] == obj.origin[i]);

    // Compare the normal arrays.
    bool normal_equal = true;
    for(i = 0; i < 3 && normal_equal; ++i)
        normal_equal = (normal[i] == obj.normal[i]);

    // Compare the upAxis arrays.
    bool upAxis_equal = true;
    for(i = 0; i < 3 && upAxis_equal; ++i)
        upAxis_equal = (upAxis[i] == obj.upAxis[i]);

    // Create the return value
    return ((angle == obj.angle) &&
            origin_equal &&
            normal_equal &&
            (representation == obj.representation) &&
            upAxis_equal &&
            (cutByLength == obj.cutByLength) &&
            (length == obj.length));
}

// ****************************************************************************
// Method: ConeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ConeAttributes::operator != (const ConeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ConeAttributes::TypeName
//
// Purpose: 
//   Type name method for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ConeAttributes::TypeName() const
{
    return "ConeAttributes";
}

// ****************************************************************************
// Method: ConeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ConeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ConeAttributes *tmp = (const ConeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ConeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ConeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ConeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ConeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ConeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ConeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ConeAttributes(*this);
    else
        retval = new ConeAttributes;

    return retval;
}

// ****************************************************************************
// Method: ConeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ConeAttributes::SelectAll()
{
    Select(0, (void *)&angle);
    Select(1, (void *)origin, 3);
    Select(2, (void *)normal, 3);
    Select(3, (void *)&representation);
    Select(4, (void *)upAxis, 3);
    Select(5, (void *)&cutByLength);
    Select(6, (void *)&length);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ConeAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ConeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ConeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ConeAttributes.
    DataNode *node = new DataNode("ConeAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("angle", angle));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("origin", origin, 3));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("normal", normal, 3));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("representation", Representation_ToString(representation)));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("upAxis", upAxis, 3));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cutByLength", cutByLength));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("length", length));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ConeAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ConeAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ConeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("angle")) != 0)
        SetAngle(node->AsDouble());
    if((node = searchNode->GetNode("origin")) != 0)
        SetOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("normal")) != 0)
        SetNormal(node->AsDoubleArray());
    if((node = searchNode->GetNode("representation")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetRepresentation(Representation(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Representation value;
            if(Representation_FromString(node->AsString(), value))
                SetRepresentation(value);
        }
    }
    if((node = searchNode->GetNode("upAxis")) != 0)
        SetUpAxis(node->AsDoubleArray());
    if((node = searchNode->GetNode("cutByLength")) != 0)
        SetCutByLength(node->AsBool());
    if((node = searchNode->GetNode("length")) != 0)
        SetLength(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ConeAttributes::SetAngle(double angle_)
{
    angle = angle_;
    Select(0, (void *)&angle);
}

void
ConeAttributes::SetOrigin(const double *origin_)
{
    origin[0] = origin_[0];
    origin[1] = origin_[1];
    origin[2] = origin_[2];
    Select(1, (void *)origin, 3);
}

void
ConeAttributes::SetNormal(const double *normal_)
{
    normal[0] = normal_[0];
    normal[1] = normal_[1];
    normal[2] = normal_[2];
    Select(2, (void *)normal, 3);
}

void
ConeAttributes::SetRepresentation(ConeAttributes::Representation representation_)
{
    representation = representation_;
    Select(3, (void *)&representation);
}

void
ConeAttributes::SetUpAxis(const double *upAxis_)
{
    upAxis[0] = upAxis_[0];
    upAxis[1] = upAxis_[1];
    upAxis[2] = upAxis_[2];
    Select(4, (void *)upAxis, 3);
}

void
ConeAttributes::SetCutByLength(bool cutByLength_)
{
    cutByLength = cutByLength_;
    Select(5, (void *)&cutByLength);
}

void
ConeAttributes::SetLength(double length_)
{
    length = length_;
    Select(6, (void *)&length);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
ConeAttributes::GetAngle() const
{
    return angle;
}

const double *
ConeAttributes::GetOrigin() const
{
    return origin;
}

double *
ConeAttributes::GetOrigin()
{
    return origin;
}

const double *
ConeAttributes::GetNormal() const
{
    return normal;
}

double *
ConeAttributes::GetNormal()
{
    return normal;
}

ConeAttributes::Representation
ConeAttributes::GetRepresentation() const
{
    return Representation(representation);
}

const double *
ConeAttributes::GetUpAxis() const
{
    return upAxis;
}

double *
ConeAttributes::GetUpAxis()
{
    return upAxis;
}

bool
ConeAttributes::GetCutByLength() const
{
    return cutByLength;
}

double
ConeAttributes::GetLength() const
{
    return length;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ConeAttributes::SelectOrigin()
{
    Select(1, (void *)origin, 3);
}

void
ConeAttributes::SelectNormal()
{
    Select(2, (void *)normal, 3);
}

void
ConeAttributes::SelectUpAxis()
{
    Select(4, (void *)upAxis, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ConeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ConeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Angle";
        case 1:  return "Origin";
        case 2:  return "Direction";
        case 3:  return "Representation";
        case 4:  return "Up Axis";
        case 5:  return "Cut cone off?";
        case 6:  return "Cone Length";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ConeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ConeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_double;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_doubleArray;
        case 3:  return FieldType_enum;
        case 4:  return FieldType_doubleArray;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ConeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ConeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "double";
        case 1:  return "doubleArray";
        case 2:  return "doubleArray";
        case 3:  return "enum";
        case 4:  return "doubleArray";
        case 5:  return "bool";
        case 6:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ConeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ConeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ConeAttributes &obj = *((const ConeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (angle == obj.angle);
        }
        break;
    case 1:
        {  // new scope
        // Compare the origin arrays.
        bool origin_equal = true;
        for(i = 0; i < 3 && origin_equal; ++i)
            origin_equal = (origin[i] == obj.origin[i]);

        retval = origin_equal;
        }
        break;
    case 2:
        {  // new scope
        // Compare the normal arrays.
        bool normal_equal = true;
        for(i = 0; i < 3 && normal_equal; ++i)
            normal_equal = (normal[i] == obj.normal[i]);

        retval = normal_equal;
        }
        break;
    case 3:
        {  // new scope
        retval = (representation == obj.representation);
        }
        break;
    case 4:
        {  // new scope
        // Compare the upAxis arrays.
        bool upAxis_equal = true;
        for(i = 0; i < 3 && upAxis_equal; ++i)
            upAxis_equal = (upAxis[i] == obj.upAxis[i]);

        retval = upAxis_equal;
        }
        break;
    case 5:
        {  // new scope
        retval = (cutByLength == obj.cutByLength);
        }
        break;
    case 6:
        {  // new scope
        retval = (length == obj.length);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

