#include <PyClipAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyClipAttributes
//
// Purpose: 
//   This class contains attributes for the clip operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Jan 16 08:38:31 PDT 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a ClipAttributes.
//
struct ClipAttributesObject
{
    PyObject_HEAD
    ClipAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewClipAttributes();

static PyObject *
ClipAttributes_Notify(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_SetFuncType(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the funcType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetFuncType(ClipAttributes::ClipStyle(ival));
    else
    {
        fprintf(stderr, "An invalid funcType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Plane, Sphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetFuncType(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFuncType()));
    return retval;
}

static PyObject *
ClipAttributes_SetPlane1Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plane1Status in the object.
    obj->data->SetPlane1Status(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane1Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlane1Status()?1L:0L);
    return retval;
}

static PyObject *
ClipAttributes_SetPlane2Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plane2Status in the object.
    obj->data->SetPlane2Status(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane2Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlane2Status()?1L:0L);
    return retval;
}

static PyObject *
ClipAttributes_SetPlane3Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plane3Status in the object.
    obj->data->SetPlane3Status(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane3Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlane3Status()?1L:0L);
    return retval;
}

static PyObject *
ClipAttributes_SetPlane1Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane1Origin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane1Origin in the object as modified.
    obj->data->SelectPlane1Origin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane1Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane1Origin.
    PyObject *retval = PyTuple_New(3);
    const double *plane1Origin = obj->data->GetPlane1Origin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane1Origin[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetPlane2Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane2Origin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane2Origin in the object as modified.
    obj->data->SelectPlane2Origin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane2Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane2Origin.
    PyObject *retval = PyTuple_New(3);
    const double *plane2Origin = obj->data->GetPlane2Origin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane2Origin[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetPlane3Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane3Origin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane3Origin in the object as modified.
    obj->data->SelectPlane3Origin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane3Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane3Origin.
    PyObject *retval = PyTuple_New(3);
    const double *plane3Origin = obj->data->GetPlane3Origin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane3Origin[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetPlane1Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane1Normal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane1Normal in the object as modified.
    obj->data->SelectPlane1Normal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane1Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane1Normal.
    PyObject *retval = PyTuple_New(3);
    const double *plane1Normal = obj->data->GetPlane1Normal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane1Normal[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetPlane2Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane2Normal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane2Normal in the object as modified.
    obj->data->SelectPlane2Normal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane2Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane2Normal.
    PyObject *retval = PyTuple_New(3);
    const double *plane2Normal = obj->data->GetPlane2Normal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane2Normal[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetPlane3Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane3Normal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane3Normal in the object as modified.
    obj->data->SelectPlane3Normal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlane3Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane3Normal.
    PyObject *retval = PyTuple_New(3);
    const double *plane3Normal = obj->data->GetPlane3Normal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane3Normal[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetPlaneInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the planeInverse in the object.
    obj->data->SetPlaneInverse(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetPlaneInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlaneInverse()?1L:0L);
    return retval;
}

static PyObject *
ClipAttributes_SetCenter(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetCenter();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the center in the object as modified.
    obj->data->SelectCenter();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetCenter(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the center.
    PyObject *retval = PyTuple_New(3);
    const double *center = obj->data->GetCenter();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(center[i]));
    return retval;
}

static PyObject *
ClipAttributes_SetRadius(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetRadius(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}

static PyObject *
ClipAttributes_SetSphereInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sphereInverse in the object.
    obj->data->SetSphereInverse(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ClipAttributes_GetSphereInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSphereInverse()?1L:0L);
    return retval;
}



static struct PyMethodDef ClipAttributes_methods[] = {
    {"Notify", ClipAttributes_Notify, METH_VARARGS},
    {"SetFuncType", ClipAttributes_SetFuncType, METH_VARARGS},
    {"GetFuncType", ClipAttributes_GetFuncType, METH_VARARGS},
    {"SetPlane1Status", ClipAttributes_SetPlane1Status, METH_VARARGS},
    {"GetPlane1Status", ClipAttributes_GetPlane1Status, METH_VARARGS},
    {"SetPlane2Status", ClipAttributes_SetPlane2Status, METH_VARARGS},
    {"GetPlane2Status", ClipAttributes_GetPlane2Status, METH_VARARGS},
    {"SetPlane3Status", ClipAttributes_SetPlane3Status, METH_VARARGS},
    {"GetPlane3Status", ClipAttributes_GetPlane3Status, METH_VARARGS},
    {"SetPlane1Origin", ClipAttributes_SetPlane1Origin, METH_VARARGS},
    {"GetPlane1Origin", ClipAttributes_GetPlane1Origin, METH_VARARGS},
    {"SetPlane2Origin", ClipAttributes_SetPlane2Origin, METH_VARARGS},
    {"GetPlane2Origin", ClipAttributes_GetPlane2Origin, METH_VARARGS},
    {"SetPlane3Origin", ClipAttributes_SetPlane3Origin, METH_VARARGS},
    {"GetPlane3Origin", ClipAttributes_GetPlane3Origin, METH_VARARGS},
    {"SetPlane1Normal", ClipAttributes_SetPlane1Normal, METH_VARARGS},
    {"GetPlane1Normal", ClipAttributes_GetPlane1Normal, METH_VARARGS},
    {"SetPlane2Normal", ClipAttributes_SetPlane2Normal, METH_VARARGS},
    {"GetPlane2Normal", ClipAttributes_GetPlane2Normal, METH_VARARGS},
    {"SetPlane3Normal", ClipAttributes_SetPlane3Normal, METH_VARARGS},
    {"GetPlane3Normal", ClipAttributes_GetPlane3Normal, METH_VARARGS},
    {"SetPlaneInverse", ClipAttributes_SetPlaneInverse, METH_VARARGS},
    {"GetPlaneInverse", ClipAttributes_GetPlaneInverse, METH_VARARGS},
    {"SetCenter", ClipAttributes_SetCenter, METH_VARARGS},
    {"GetCenter", ClipAttributes_GetCenter, METH_VARARGS},
    {"SetRadius", ClipAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", ClipAttributes_GetRadius, METH_VARARGS},
    {"SetSphereInverse", ClipAttributes_SetSphereInverse, METH_VARARGS},
    {"GetSphereInverse", ClipAttributes_GetSphereInverse, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ClipAttributes_dealloc(PyObject *v)
{
   ClipAttributesObject *obj = (ClipAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ClipAttributes_compare(PyObject *v, PyObject *w)
{
    ClipAttributes *a = ((ClipAttributesObject *)v)->data;
    ClipAttributes *b = ((ClipAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ClipAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "funcType") == 0)
        return ClipAttributes_GetFuncType(self, NULL);
    if(strcmp(name, "Plane") == 0)
        return PyInt_FromLong(long(ClipAttributes::Plane));
    else if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(ClipAttributes::Sphere));

    if(strcmp(name, "plane1Status") == 0)
        return ClipAttributes_GetPlane1Status(self, NULL);
    if(strcmp(name, "plane2Status") == 0)
        return ClipAttributes_GetPlane2Status(self, NULL);
    if(strcmp(name, "plane3Status") == 0)
        return ClipAttributes_GetPlane3Status(self, NULL);
    if(strcmp(name, "plane1Origin") == 0)
        return ClipAttributes_GetPlane1Origin(self, NULL);
    if(strcmp(name, "plane2Origin") == 0)
        return ClipAttributes_GetPlane2Origin(self, NULL);
    if(strcmp(name, "plane3Origin") == 0)
        return ClipAttributes_GetPlane3Origin(self, NULL);
    if(strcmp(name, "plane1Normal") == 0)
        return ClipAttributes_GetPlane1Normal(self, NULL);
    if(strcmp(name, "plane2Normal") == 0)
        return ClipAttributes_GetPlane2Normal(self, NULL);
    if(strcmp(name, "plane3Normal") == 0)
        return ClipAttributes_GetPlane3Normal(self, NULL);
    if(strcmp(name, "planeInverse") == 0)
        return ClipAttributes_GetPlaneInverse(self, NULL);
    if(strcmp(name, "center") == 0)
        return ClipAttributes_GetCenter(self, NULL);
    if(strcmp(name, "radius") == 0)
        return ClipAttributes_GetRadius(self, NULL);
    if(strcmp(name, "sphereInverse") == 0)
        return ClipAttributes_GetSphereInverse(self, NULL);

    return Py_FindMethod(ClipAttributes_methods, self, name);
}

static int
ClipAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "funcType") == 0)
        retval = (ClipAttributes_SetFuncType(self, tuple) != NULL);
    else if(strcmp(name, "plane1Status") == 0)
        retval = (ClipAttributes_SetPlane1Status(self, tuple) != NULL);
    else if(strcmp(name, "plane2Status") == 0)
        retval = (ClipAttributes_SetPlane2Status(self, tuple) != NULL);
    else if(strcmp(name, "plane3Status") == 0)
        retval = (ClipAttributes_SetPlane3Status(self, tuple) != NULL);
    else if(strcmp(name, "plane1Origin") == 0)
        retval = (ClipAttributes_SetPlane1Origin(self, tuple) != NULL);
    else if(strcmp(name, "plane2Origin") == 0)
        retval = (ClipAttributes_SetPlane2Origin(self, tuple) != NULL);
    else if(strcmp(name, "plane3Origin") == 0)
        retval = (ClipAttributes_SetPlane3Origin(self, tuple) != NULL);
    else if(strcmp(name, "plane1Normal") == 0)
        retval = (ClipAttributes_SetPlane1Normal(self, tuple) != NULL);
    else if(strcmp(name, "plane2Normal") == 0)
        retval = (ClipAttributes_SetPlane2Normal(self, tuple) != NULL);
    else if(strcmp(name, "plane3Normal") == 0)
        retval = (ClipAttributes_SetPlane3Normal(self, tuple) != NULL);
    else if(strcmp(name, "planeInverse") == 0)
        retval = (ClipAttributes_SetPlaneInverse(self, tuple) != NULL);
    else if(strcmp(name, "center") == 0)
        retval = (ClipAttributes_SetCenter(self, tuple) != NULL);
    else if(strcmp(name, "radius") == 0)
        retval = (ClipAttributes_SetRadius(self, tuple) != NULL);
    else if(strcmp(name, "sphereInverse") == 0)
        retval = (ClipAttributes_SetSphereInverse(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ClipAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)v;

    const char *funcType_names = "Plane, Sphere";
    if(obj->data->GetFuncType() == ClipAttributes::Plane)
        fprintf(fp, "funcType = Plane  # %s\n", funcType_names);
    else
        fprintf(fp, "funcType = Sphere  # %s\n", funcType_names);

    if(obj->data->GetPlane1Status())
        fprintf(fp, "plane1Status = 1\n");
    else
        fprintf(fp, "plane1Status = 0\n");
    if(obj->data->GetPlane2Status())
        fprintf(fp, "plane2Status = 1\n");
    else
        fprintf(fp, "plane2Status = 0\n");
    if(obj->data->GetPlane3Status())
        fprintf(fp, "plane3Status = 1\n");
    else
        fprintf(fp, "plane3Status = 0\n");
    {   const double *plane1Origin = obj->data->GetPlane1Origin();
        fprintf(fp, "plane1Origin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", plane1Origin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *plane2Origin = obj->data->GetPlane2Origin();
        fprintf(fp, "plane2Origin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", plane2Origin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *plane3Origin = obj->data->GetPlane3Origin();
        fprintf(fp, "plane3Origin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", plane3Origin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *plane1Normal = obj->data->GetPlane1Normal();
        fprintf(fp, "plane1Normal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", plane1Normal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *plane2Normal = obj->data->GetPlane2Normal();
        fprintf(fp, "plane2Normal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", plane2Normal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *plane3Normal = obj->data->GetPlane3Normal();
        fprintf(fp, "plane3Normal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", plane3Normal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetPlaneInverse())
        fprintf(fp, "planeInverse = 1\n");
    else
        fprintf(fp, "planeInverse = 0\n");
    {   const double *center = obj->data->GetCenter();
        fprintf(fp, "center = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", center[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "radius = %g\n", obj->data->GetRadius());
    if(obj->data->GetSphereInverse())
        fprintf(fp, "sphereInverse = 1\n");
    else
        fprintf(fp, "sphereInverse = 0\n");

    return 0;
}

//
// The doc string for the class.
//
static char *ClipAttributes_Purpose = "This class contains attributes for the clip operator.";

//
// The type description structure
//
static PyTypeObject ClipAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ClipAttributes",                    // tp_name
    sizeof(ClipAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ClipAttributes_dealloc,  // tp_dealloc
    (printfunc)ClipAttributes_print,     // tp_print
    (getattrfunc)ClipAttributes_getattr, // tp_getattr
    (setattrfunc)ClipAttributes_setattr, // tp_setattr
    (cmpfunc)ClipAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ClipAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ClipAttributes *defaultAtts = 0;

static PyObject *
NewClipAttributes()
{
    ClipAttributesObject *newObject;
    newObject = PyObject_NEW(ClipAttributesObject, &ClipAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ClipAttributes(*defaultAtts);
    else
        newObject->data = new ClipAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapClipAttributes(const ClipAttributes *attr)
{
    ClipAttributesObject *newObject;
    newObject = PyObject_NEW(ClipAttributesObject, &ClipAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ClipAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ClipAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewClipAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ClipAttributesMethods[] = {
    {"ClipAttributes", ClipAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ClipAttributesObserver = 0;
static bool ClipAttributesEnableLogging = true;

static void
PyClipAttributes_WriteLog(Subject *subj, void *data)
{
    ClipAttributes *atts = (ClipAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ClipAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ClipAttributes_WriteLog()\n");
}

void
PyClipAttributes_StartUp(ClipAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyClipAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ClipAttributesObserver == 0)
    {
        ClipAttributesObserver = new ObserverToCallback(subj,
            PyClipAttributes_WriteLog, (void *)logFile);
    }

    ClipAttributesEnableLogging = true;
}

void
PyClipAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ClipAttributesObserver;
    ClipAttributesObserver = 0;
}

PyMethodDef *
PyClipAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ClipAttributesMethods;
}

bool
PyClipAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ClipAttributesType);
}

ClipAttributes *
PyClipAttributes_FromPyObject(PyObject *obj)
{
    ClipAttributesObject *obj2 = (ClipAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyClipAttributes_NewPyObject()
{
    return NewClipAttributes();
}

PyObject *
PyClipAttributes_WrapPyObject(const ClipAttributes *attr)
{
    return WrapClipAttributes(attr);
}

void
PyClipAttributes_SetLogging(bool val)
{
    ClipAttributesEnableLogging = val;
}

void
PyClipAttributes_SetDefaults(const ClipAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ClipAttributes(*atts);
}

