// ************************************************************************* //
//  File: ClipViewerPluginInfo.C
// ************************************************************************* //

#include <ClipPluginInfo.h>
#include <ClipAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Clip_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Clip operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ClipViewerPluginInfo::InitializeGlobalObjects();
    return new ClipViewerPluginInfo;
}

//
// Storage for static data elements.
//
ClipAttributes *ClipViewerPluginInfo::clientAtts = NULL;
ClipAttributes *ClipViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ClipViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************
void
ClipViewerPluginInfo::InitializeGlobalObjects()
{
    ClipViewerPluginInfo::clientAtts  = new ClipAttributes;
    ClipViewerPluginInfo::defaultAtts = new ClipAttributes;
}

// ****************************************************************************
//  Method: ClipViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************

AttributeSubject *
ClipViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ClipViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************

AttributeSubject *
ClipViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ClipViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************

void
ClipViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ClipAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ClipViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************

void
ClipViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ClipAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ClipViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************

void
ClipViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ClipAttributes*)atts = *defaultAtts;
    else
        *(ClipAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ClipViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:01:13 PST 2003
//
// ****************************************************************************

#include <Clip.xpm>
const char **
ClipViewerPluginInfo::XPMIconData() const
{
    return Clip_xpm;
}
