// ************************************************************************* //
//                        ClipScriptingPluginInfo.C
// ************************************************************************* //
#include <ClipPluginInfo.h>
#include <PyClipAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Clip_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Clip plot.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Jan 16 08:38:30 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ClipScriptingPluginInfo;
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Jan 16 08:38:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ClipScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyClipAttributes_StartUp((ClipAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Jan 16 08:38:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
ClipScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyClipAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Clip plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Jan 16 08:38:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ClipScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyClipAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Jan 16 08:38:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ClipScriptingPluginInfo::SetLogging(bool val)
{
    PyClipAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Jan 16 08:38:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ClipScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyClipAttributes_SetDefaults((const ClipAttributes *)atts);
}
