// ************************************************************************* //
//  File: ClipGUIPluginInfo.C
// ************************************************************************* //

#include <ClipPluginInfo.h>
#include <ClipAttributes.h>
#include <QvisClipWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Clip_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Clip operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 14:08:07 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ClipGUIPluginInfo;
}

// ****************************************************************************
//  Method: ClipGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 14:08:07 PST 2003
//
// ****************************************************************************

const char *
ClipGUIPluginInfo::GetMenuName() const
{
    return "Clip";
}


// ****************************************************************************
//  Method: ClipGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 14:08:07 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
ClipGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisClipWindow(type, (ClipAttributes *)attr,
        "Clip operator attributes", "Clip operator", notepad);
}

// ****************************************************************************
//  Method: ClipGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 14:08:07 PST 2003
//
// ****************************************************************************

#include <Clip.xpm>
const char **
ClipGUIPluginInfo::XPMIconData() const
{
    return Clip_xpm;
}
