#include <ClipAttributes.h>
#include <DataNode.h>
#include <BoxExtents.h>
#include <SphereAttributes.h>

//
// Enum conversion methods for ClipAttributes::ClipStyle
//

static const char *ClipStyle_strings[] = {
"Plane", "Sphere"};

std::string
ClipAttributes::ClipStyle_ToString(ClipAttributes::ClipStyle t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ClipStyle_strings[index];
}

std::string
ClipAttributes::ClipStyle_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ClipStyle_strings[index];
}

bool
ClipAttributes::ClipStyle_FromString(const std::string &s, ClipAttributes::ClipStyle &val)
{
    val = ClipAttributes::Plane;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ClipStyle_strings[i])
        {
            val = (ClipStyle)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ClipAttributes::ClipAttributes
//
// Purpose: 
//   Constructor for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ClipAttributes::ClipAttributes() : AttributeSubject("ibbbDDDDDDbDdb")
{
    funcType = Plane;
    plane1Status = true;
    plane2Status = false;
    plane3Status = false;
    plane1Origin[0] = 0;
    plane1Origin[1] = 0;
    plane1Origin[2] = 0;
    plane2Origin[0] = 0;
    plane2Origin[1] = 0;
    plane2Origin[2] = 0;
    plane3Origin[0] = 0;
    plane3Origin[1] = 0;
    plane3Origin[2] = 0;
    plane1Normal[0] = 1;
    plane1Normal[1] = 0;
    plane1Normal[2] = 0;
    plane2Normal[0] = 0;
    plane2Normal[1] = 1;
    plane2Normal[2] = 0;
    plane3Normal[0] = 0;
    plane3Normal[1] = 0;
    plane3Normal[2] = 1;
    planeInverse = false;
    center[0] = 0;
    center[1] = 0;
    center[2] = 0;
    radius = 1;
    sphereInverse = false;
}

// ****************************************************************************
// Method: ClipAttributes::ClipAttributes
//
// Purpose: 
//   Copy constructor for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ClipAttributes::ClipAttributes(const ClipAttributes &obj) : AttributeSubject("ibbbDDDDDDbDdb")
{
    funcType = obj.funcType;
    plane1Status = obj.plane1Status;
    plane2Status = obj.plane2Status;
    plane3Status = obj.plane3Status;
    plane1Origin[0] = obj.plane1Origin[0];
    plane1Origin[1] = obj.plane1Origin[1];
    plane1Origin[2] = obj.plane1Origin[2];

    plane2Origin[0] = obj.plane2Origin[0];
    plane2Origin[1] = obj.plane2Origin[1];
    plane2Origin[2] = obj.plane2Origin[2];

    plane3Origin[0] = obj.plane3Origin[0];
    plane3Origin[1] = obj.plane3Origin[1];
    plane3Origin[2] = obj.plane3Origin[2];

    plane1Normal[0] = obj.plane1Normal[0];
    plane1Normal[1] = obj.plane1Normal[1];
    plane1Normal[2] = obj.plane1Normal[2];

    plane2Normal[0] = obj.plane2Normal[0];
    plane2Normal[1] = obj.plane2Normal[1];
    plane2Normal[2] = obj.plane2Normal[2];

    plane3Normal[0] = obj.plane3Normal[0];
    plane3Normal[1] = obj.plane3Normal[1];
    plane3Normal[2] = obj.plane3Normal[2];

    planeInverse = obj.planeInverse;
    center[0] = obj.center[0];
    center[1] = obj.center[1];
    center[2] = obj.center[2];

    radius = obj.radius;
    sphereInverse = obj.sphereInverse;

    SelectAll();
}

// ****************************************************************************
// Method: ClipAttributes::~ClipAttributes
//
// Purpose: 
//   Destructor for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ClipAttributes::~ClipAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ClipAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ClipAttributes::operator = (const ClipAttributes &obj)
{
    funcType = obj.funcType;
    plane1Status = obj.plane1Status;
    plane2Status = obj.plane2Status;
    plane3Status = obj.plane3Status;
    plane1Origin[0] = obj.plane1Origin[0];
    plane1Origin[1] = obj.plane1Origin[1];
    plane1Origin[2] = obj.plane1Origin[2];

    plane2Origin[0] = obj.plane2Origin[0];
    plane2Origin[1] = obj.plane2Origin[1];
    plane2Origin[2] = obj.plane2Origin[2];

    plane3Origin[0] = obj.plane3Origin[0];
    plane3Origin[1] = obj.plane3Origin[1];
    plane3Origin[2] = obj.plane3Origin[2];

    plane1Normal[0] = obj.plane1Normal[0];
    plane1Normal[1] = obj.plane1Normal[1];
    plane1Normal[2] = obj.plane1Normal[2];

    plane2Normal[0] = obj.plane2Normal[0];
    plane2Normal[1] = obj.plane2Normal[1];
    plane2Normal[2] = obj.plane2Normal[2];

    plane3Normal[0] = obj.plane3Normal[0];
    plane3Normal[1] = obj.plane3Normal[1];
    plane3Normal[2] = obj.plane3Normal[2];

    planeInverse = obj.planeInverse;
    center[0] = obj.center[0];
    center[1] = obj.center[1];
    center[2] = obj.center[2];

    radius = obj.radius;
    sphereInverse = obj.sphereInverse;

    SelectAll();
}

// ****************************************************************************
// Method: ClipAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ClipAttributes::operator == (const ClipAttributes &obj) const
{
    int i;

    // Compare the plane1Origin arrays.
    bool plane1Origin_equal = true;
    for(i = 0; i < 3 && plane1Origin_equal; ++i)
        plane1Origin_equal = (plane1Origin[i] == obj.plane1Origin[i]);

    // Compare the plane2Origin arrays.
    bool plane2Origin_equal = true;
    for(i = 0; i < 3 && plane2Origin_equal; ++i)
        plane2Origin_equal = (plane2Origin[i] == obj.plane2Origin[i]);

    // Compare the plane3Origin arrays.
    bool plane3Origin_equal = true;
    for(i = 0; i < 3 && plane3Origin_equal; ++i)
        plane3Origin_equal = (plane3Origin[i] == obj.plane3Origin[i]);

    // Compare the plane1Normal arrays.
    bool plane1Normal_equal = true;
    for(i = 0; i < 3 && plane1Normal_equal; ++i)
        plane1Normal_equal = (plane1Normal[i] == obj.plane1Normal[i]);

    // Compare the plane2Normal arrays.
    bool plane2Normal_equal = true;
    for(i = 0; i < 3 && plane2Normal_equal; ++i)
        plane2Normal_equal = (plane2Normal[i] == obj.plane2Normal[i]);

    // Compare the plane3Normal arrays.
    bool plane3Normal_equal = true;
    for(i = 0; i < 3 && plane3Normal_equal; ++i)
        plane3Normal_equal = (plane3Normal[i] == obj.plane3Normal[i]);

    // Compare the center arrays.
    bool center_equal = true;
    for(i = 0; i < 3 && center_equal; ++i)
        center_equal = (center[i] == obj.center[i]);

    // Create the return value
    return ((funcType == obj.funcType) &&
            (plane1Status == obj.plane1Status) &&
            (plane2Status == obj.plane2Status) &&
            (plane3Status == obj.plane3Status) &&
            plane1Origin_equal &&
            plane2Origin_equal &&
            plane3Origin_equal &&
            plane1Normal_equal &&
            plane2Normal_equal &&
            plane3Normal_equal &&
            (planeInverse == obj.planeInverse) &&
            center_equal &&
            (radius == obj.radius) &&
            (sphereInverse == obj.sphereInverse));
}

// ****************************************************************************
// Method: ClipAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ClipAttributes::operator != (const ClipAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ClipAttributes::TypeName
//
// Purpose: 
//   Type name method for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ClipAttributes::TypeName() const
{
    return "ClipAttributes";
}

// ****************************************************************************
// Method: ClipAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ClipAttributes class.
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct 29 08:57:18 PDT 2002
//
// Modifications:
//
// ****************************************************************************

bool
ClipAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const ClipAttributes *tmp = (const ClipAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "BoxExtents")
    {
        if(GetFuncType() == Plane)
        {
            const BoxExtents *tmp = (const BoxExtents *)atts;
            const double *extents = tmp->GetExtents();
            double origin[] = {extents[0], extents[2], extents[4]};
            double xnorm[] = {1., 0., 0.};
            double ynorm[] = {0., 1., 0.};
            double znorm[] = {0., 0., 1.};
            if(GetPlane1Status())
            {
                SetPlane1Origin(origin);
                SetPlane1Normal(xnorm);
            }
            if(GetPlane2Status())
            {
                SetPlane2Origin(origin);
                SetPlane2Normal(ynorm);
            }
            if(GetPlane3Status())
            {
                SetPlane3Origin(origin);
                SetPlane3Normal(znorm);
            }

            retval = true;
        }
    }
    else if(atts->TypeName() == "SphereAttributes")
    {
        if(GetFuncType() == Sphere)
        {
            const SphereAttributes *sphere = (const SphereAttributes *)atts;
            SetCenter(sphere->GetOrigin());
            SetRadius(sphere->GetRadius());

            retval = true;
        }
    }

    return retval;
}

// ****************************************************************************
// Method: ClipAttributes::CreateCompatible
//
// Purpose: 
//   Creates an object of the specified type initialized with the attributes
//   from this object.
//
// Arguments:
//   tname : The typename of the object that we want to create.
//
// Returns:    A new object of the type specified by tname or 0.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct 29 08:57:46 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ClipAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new ClipAttributes(*this);
    }
    else if(tname == "BoxExtents")
    {
        BoxExtents *b = new BoxExtents;
        double extents[6];
        extents[0] = plane1Origin[0];
        extents[1] = plane1Origin[0]+2.;
        extents[2] = plane1Origin[1];
        extents[3] = plane1Origin[1]+2.;
        extents[4] = plane1Origin[2];
        extents[5] = plane1Origin[2]+2.;
        b->SetExtents(extents);

        retval = b;
    }
    else if(tname == "SphereAttributes")
    {
        SphereAttributes *s = new SphereAttributes;
        s->SetOrigin(center);
        s->SetRadius(radius);

        retval = s;
    }

    return retval;
}

// ****************************************************************************
// Method: ClipAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ClipAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ClipAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ClipAttributes(*this);
    else
        retval = new ClipAttributes;

    return retval;
}

// ****************************************************************************
// Method: ClipAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ClipAttributes::SelectAll()
{
    Select(0, (void *)&funcType);
    Select(1, (void *)&plane1Status);
    Select(2, (void *)&plane2Status);
    Select(3, (void *)&plane3Status);
    Select(4, (void *)plane1Origin, 3);
    Select(5, (void *)plane2Origin, 3);
    Select(6, (void *)plane3Origin, 3);
    Select(7, (void *)plane1Normal, 3);
    Select(8, (void *)plane2Normal, 3);
    Select(9, (void *)plane3Normal, 3);
    Select(10, (void *)&planeInverse);
    Select(11, (void *)center, 3);
    Select(12, (void *)&radius);
    Select(13, (void *)&sphereInverse);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ClipAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ClipAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ClipAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ClipAttributes.
    DataNode *node = new DataNode("ClipAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("funcType", ClipStyle_ToString(funcType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane1Status", plane1Status));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane2Status", plane2Status));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane3Status", plane3Status));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane1Origin", plane1Origin, 3));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane2Origin", plane2Origin, 3));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane3Origin", plane3Origin, 3));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane1Normal", plane1Normal, 3));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane2Normal", plane2Normal, 3));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("plane3Normal", plane3Normal, 3));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("planeInverse", planeInverse));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("center", center, 3));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radius", radius));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sphereInverse", sphereInverse));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ClipAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ClipAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ClipAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("funcType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetFuncType(ClipStyle(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ClipStyle value;
            if(ClipStyle_FromString(node->AsString(), value))
                SetFuncType(value);
        }
    }
    if((node = searchNode->GetNode("plane1Status")) != 0)
        SetPlane1Status(node->AsBool());
    if((node = searchNode->GetNode("plane2Status")) != 0)
        SetPlane2Status(node->AsBool());
    if((node = searchNode->GetNode("plane3Status")) != 0)
        SetPlane3Status(node->AsBool());
    if((node = searchNode->GetNode("plane1Origin")) != 0)
        SetPlane1Origin(node->AsDoubleArray());
    if((node = searchNode->GetNode("plane2Origin")) != 0)
        SetPlane2Origin(node->AsDoubleArray());
    if((node = searchNode->GetNode("plane3Origin")) != 0)
        SetPlane3Origin(node->AsDoubleArray());
    if((node = searchNode->GetNode("plane1Normal")) != 0)
        SetPlane1Normal(node->AsDoubleArray());
    if((node = searchNode->GetNode("plane2Normal")) != 0)
        SetPlane2Normal(node->AsDoubleArray());
    if((node = searchNode->GetNode("plane3Normal")) != 0)
        SetPlane3Normal(node->AsDoubleArray());
    if((node = searchNode->GetNode("planeInverse")) != 0)
        SetPlaneInverse(node->AsBool());
    if((node = searchNode->GetNode("center")) != 0)
        SetCenter(node->AsDoubleArray());
    if((node = searchNode->GetNode("radius")) != 0)
        SetRadius(node->AsDouble());
    if((node = searchNode->GetNode("sphereInverse")) != 0)
        SetSphereInverse(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ClipAttributes::SetFuncType(ClipAttributes::ClipStyle funcType_)
{
    funcType = funcType_;
    Select(0, (void *)&funcType);
}

void
ClipAttributes::SetPlane1Status(bool plane1Status_)
{
    plane1Status = plane1Status_;
    Select(1, (void *)&plane1Status);
}

void
ClipAttributes::SetPlane2Status(bool plane2Status_)
{
    plane2Status = plane2Status_;
    Select(2, (void *)&plane2Status);
}

void
ClipAttributes::SetPlane3Status(bool plane3Status_)
{
    plane3Status = plane3Status_;
    Select(3, (void *)&plane3Status);
}

void
ClipAttributes::SetPlane1Origin(const double *plane1Origin_)
{
    plane1Origin[0] = plane1Origin_[0];
    plane1Origin[1] = plane1Origin_[1];
    plane1Origin[2] = plane1Origin_[2];
    Select(4, (void *)plane1Origin, 3);
}

void
ClipAttributes::SetPlane2Origin(const double *plane2Origin_)
{
    plane2Origin[0] = plane2Origin_[0];
    plane2Origin[1] = plane2Origin_[1];
    plane2Origin[2] = plane2Origin_[2];
    Select(5, (void *)plane2Origin, 3);
}

void
ClipAttributes::SetPlane3Origin(const double *plane3Origin_)
{
    plane3Origin[0] = plane3Origin_[0];
    plane3Origin[1] = plane3Origin_[1];
    plane3Origin[2] = plane3Origin_[2];
    Select(6, (void *)plane3Origin, 3);
}

void
ClipAttributes::SetPlane1Normal(const double *plane1Normal_)
{
    plane1Normal[0] = plane1Normal_[0];
    plane1Normal[1] = plane1Normal_[1];
    plane1Normal[2] = plane1Normal_[2];
    Select(7, (void *)plane1Normal, 3);
}

void
ClipAttributes::SetPlane2Normal(const double *plane2Normal_)
{
    plane2Normal[0] = plane2Normal_[0];
    plane2Normal[1] = plane2Normal_[1];
    plane2Normal[2] = plane2Normal_[2];
    Select(8, (void *)plane2Normal, 3);
}

void
ClipAttributes::SetPlane3Normal(const double *plane3Normal_)
{
    plane3Normal[0] = plane3Normal_[0];
    plane3Normal[1] = plane3Normal_[1];
    plane3Normal[2] = plane3Normal_[2];
    Select(9, (void *)plane3Normal, 3);
}

void
ClipAttributes::SetPlaneInverse(bool planeInverse_)
{
    planeInverse = planeInverse_;
    Select(10, (void *)&planeInverse);
}

void
ClipAttributes::SetCenter(const double *center_)
{
    center[0] = center_[0];
    center[1] = center_[1];
    center[2] = center_[2];
    Select(11, (void *)center, 3);
}

void
ClipAttributes::SetRadius(double radius_)
{
    radius = radius_;
    Select(12, (void *)&radius);
}

void
ClipAttributes::SetSphereInverse(bool sphereInverse_)
{
    sphereInverse = sphereInverse_;
    Select(13, (void *)&sphereInverse);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ClipAttributes::ClipStyle
ClipAttributes::GetFuncType() const
{
    return ClipStyle(funcType);
}

bool
ClipAttributes::GetPlane1Status() const
{
    return plane1Status;
}

bool
ClipAttributes::GetPlane2Status() const
{
    return plane2Status;
}

bool
ClipAttributes::GetPlane3Status() const
{
    return plane3Status;
}

const double *
ClipAttributes::GetPlane1Origin() const
{
    return plane1Origin;
}

double *
ClipAttributes::GetPlane1Origin()
{
    return plane1Origin;
}

const double *
ClipAttributes::GetPlane2Origin() const
{
    return plane2Origin;
}

double *
ClipAttributes::GetPlane2Origin()
{
    return plane2Origin;
}

const double *
ClipAttributes::GetPlane3Origin() const
{
    return plane3Origin;
}

double *
ClipAttributes::GetPlane3Origin()
{
    return plane3Origin;
}

const double *
ClipAttributes::GetPlane1Normal() const
{
    return plane1Normal;
}

double *
ClipAttributes::GetPlane1Normal()
{
    return plane1Normal;
}

const double *
ClipAttributes::GetPlane2Normal() const
{
    return plane2Normal;
}

double *
ClipAttributes::GetPlane2Normal()
{
    return plane2Normal;
}

const double *
ClipAttributes::GetPlane3Normal() const
{
    return plane3Normal;
}

double *
ClipAttributes::GetPlane3Normal()
{
    return plane3Normal;
}

bool
ClipAttributes::GetPlaneInverse() const
{
    return planeInverse;
}

const double *
ClipAttributes::GetCenter() const
{
    return center;
}

double *
ClipAttributes::GetCenter()
{
    return center;
}

double
ClipAttributes::GetRadius() const
{
    return radius;
}

bool
ClipAttributes::GetSphereInverse() const
{
    return sphereInverse;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ClipAttributes::SelectPlane1Origin()
{
    Select(4, (void *)plane1Origin, 3);
}

void
ClipAttributes::SelectPlane2Origin()
{
    Select(5, (void *)plane2Origin, 3);
}

void
ClipAttributes::SelectPlane3Origin()
{
    Select(6, (void *)plane3Origin, 3);
}

void
ClipAttributes::SelectPlane1Normal()
{
    Select(7, (void *)plane1Normal, 3);
}

void
ClipAttributes::SelectPlane2Normal()
{
    Select(8, (void *)plane2Normal, 3);
}

void
ClipAttributes::SelectPlane3Normal()
{
    Select(9, (void *)plane3Normal, 3);
}

void
ClipAttributes::SelectCenter()
{
    Select(11, (void *)center, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ClipAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ClipAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Style";
        case 1:  return "Plane 1";
        case 2:  return "Plane 2";
        case 3:  return "Plane 3";
        case 4:  return "Plane 1 origin";
        case 5:  return "Plane 2 origin";
        case 6:  return "Plane 3 origin";
        case 7:  return "Plane 1 normal";
        case 8:  return "Plane 2 normal";
        case 9:  return "Plane 3 normal";
        case 10:  return "Inverse";
        case 11:  return "Center";
        case 12:  return "Radius";
        case 13:  return "Inverse";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ClipAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ClipAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_doubleArray;
        case 5:  return FieldType_doubleArray;
        case 6:  return FieldType_doubleArray;
        case 7:  return FieldType_doubleArray;
        case 8:  return FieldType_doubleArray;
        case 9:  return FieldType_doubleArray;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_doubleArray;
        case 12:  return FieldType_double;
        case 13:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ClipAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ClipAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "doubleArray";
        case 5:  return "doubleArray";
        case 6:  return "doubleArray";
        case 7:  return "doubleArray";
        case 8:  return "doubleArray";
        case 9:  return "doubleArray";
        case 10:  return "bool";
        case 11:  return "doubleArray";
        case 12:  return "double";
        case 13:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ClipAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:24 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ClipAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ClipAttributes &obj = *((const ClipAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (funcType == obj.funcType);
        }
        break;
    case 1:
        {  // new scope
        retval = (plane1Status == obj.plane1Status);
        }
        break;
    case 2:
        {  // new scope
        retval = (plane2Status == obj.plane2Status);
        }
        break;
    case 3:
        {  // new scope
        retval = (plane3Status == obj.plane3Status);
        }
        break;
    case 4:
        {  // new scope
        // Compare the plane1Origin arrays.
        bool plane1Origin_equal = true;
        for(i = 0; i < 3 && plane1Origin_equal; ++i)
            plane1Origin_equal = (plane1Origin[i] == obj.plane1Origin[i]);

        retval = plane1Origin_equal;
        }
        break;
    case 5:
        {  // new scope
        // Compare the plane2Origin arrays.
        bool plane2Origin_equal = true;
        for(i = 0; i < 3 && plane2Origin_equal; ++i)
            plane2Origin_equal = (plane2Origin[i] == obj.plane2Origin[i]);

        retval = plane2Origin_equal;
        }
        break;
    case 6:
        {  // new scope
        // Compare the plane3Origin arrays.
        bool plane3Origin_equal = true;
        for(i = 0; i < 3 && plane3Origin_equal; ++i)
            plane3Origin_equal = (plane3Origin[i] == obj.plane3Origin[i]);

        retval = plane3Origin_equal;
        }
        break;
    case 7:
        {  // new scope
        // Compare the plane1Normal arrays.
        bool plane1Normal_equal = true;
        for(i = 0; i < 3 && plane1Normal_equal; ++i)
            plane1Normal_equal = (plane1Normal[i] == obj.plane1Normal[i]);

        retval = plane1Normal_equal;
        }
        break;
    case 8:
        {  // new scope
        // Compare the plane2Normal arrays.
        bool plane2Normal_equal = true;
        for(i = 0; i < 3 && plane2Normal_equal; ++i)
            plane2Normal_equal = (plane2Normal[i] == obj.plane2Normal[i]);

        retval = plane2Normal_equal;
        }
        break;
    case 9:
        {  // new scope
        // Compare the plane3Normal arrays.
        bool plane3Normal_equal = true;
        for(i = 0; i < 3 && plane3Normal_equal; ++i)
            plane3Normal_equal = (plane3Normal[i] == obj.plane3Normal[i]);

        retval = plane3Normal_equal;
        }
        break;
    case 10:
        {  // new scope
        retval = (planeInverse == obj.planeInverse);
        }
        break;
    case 11:
        {  // new scope
        // Compare the center arrays.
        bool center_equal = true;
        for(i = 0; i < 3 && center_equal; ++i)
            center_equal = (center[i] == obj.center[i]);

        retval = center_equal;
        }
        break;
    case 12:
        {  // new scope
        retval = (radius == obj.radius);
        }
        break;
    case 13:
        {  // new scope
        retval = (sphereInverse == obj.sphereInverse);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

