#include <PyBoxAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyBoxAttributes
//
// Purpose: 
//   This class contains attributes for the box operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Oct 29 09:08:37 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a BoxAttributes.
//
struct BoxAttributesObject
{
    PyObject_HEAD
    BoxAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewBoxAttributes();

static PyObject *
BoxAttributes_Notify(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_SetAmount(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the amount in the object.
    obj->data->SetAmount(BoxAttributes::Amount(ival));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetAmount(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAmount()));
    return retval;
}

static PyObject *
BoxAttributes_SetMinx(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minx in the object.
    obj->data->SetMinx(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetMinx(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinx());
    return retval;
}

static PyObject *
BoxAttributes_SetMaxx(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxx in the object.
    obj->data->SetMaxx(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetMaxx(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxx());
    return retval;
}

static PyObject *
BoxAttributes_SetMiny(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the miny in the object.
    obj->data->SetMiny(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetMiny(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMiny());
    return retval;
}

static PyObject *
BoxAttributes_SetMaxy(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxy in the object.
    obj->data->SetMaxy(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetMaxy(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxy());
    return retval;
}

static PyObject *
BoxAttributes_SetMinz(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minz in the object.
    obj->data->SetMinz(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetMinz(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinz());
    return retval;
}

static PyObject *
BoxAttributes_SetMaxz(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxz in the object.
    obj->data->SetMaxz(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoxAttributes_GetMaxz(PyObject *self, PyObject *args)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxz());
    return retval;
}



static struct PyMethodDef BoxAttributes_methods[] = {
    {"Notify", BoxAttributes_Notify, METH_VARARGS},
    {"SetAmount", BoxAttributes_SetAmount, METH_VARARGS},
    {"GetAmount", BoxAttributes_GetAmount, METH_VARARGS},
    {"SetMinx", BoxAttributes_SetMinx, METH_VARARGS},
    {"GetMinx", BoxAttributes_GetMinx, METH_VARARGS},
    {"SetMaxx", BoxAttributes_SetMaxx, METH_VARARGS},
    {"GetMaxx", BoxAttributes_GetMaxx, METH_VARARGS},
    {"SetMiny", BoxAttributes_SetMiny, METH_VARARGS},
    {"GetMiny", BoxAttributes_GetMiny, METH_VARARGS},
    {"SetMaxy", BoxAttributes_SetMaxy, METH_VARARGS},
    {"GetMaxy", BoxAttributes_GetMaxy, METH_VARARGS},
    {"SetMinz", BoxAttributes_SetMinz, METH_VARARGS},
    {"GetMinz", BoxAttributes_GetMinz, METH_VARARGS},
    {"SetMaxz", BoxAttributes_SetMaxz, METH_VARARGS},
    {"GetMaxz", BoxAttributes_GetMaxz, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
BoxAttributes_dealloc(PyObject *v)
{
   BoxAttributesObject *obj = (BoxAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
BoxAttributes_compare(PyObject *v, PyObject *w)
{
    BoxAttributes *a = ((BoxAttributesObject *)v)->data;
    BoxAttributes *b = ((BoxAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
BoxAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "amount") == 0)
        return BoxAttributes_GetAmount(self, NULL);
    if(strcmp(name, "Some") == 0)
        return PyInt_FromLong(long(BoxAttributes::Some));
    else if(strcmp(name, "All") == 0)
        return PyInt_FromLong(long(BoxAttributes::All));

    if(strcmp(name, "minx") == 0)
        return BoxAttributes_GetMinx(self, NULL);
    if(strcmp(name, "maxx") == 0)
        return BoxAttributes_GetMaxx(self, NULL);
    if(strcmp(name, "miny") == 0)
        return BoxAttributes_GetMiny(self, NULL);
    if(strcmp(name, "maxy") == 0)
        return BoxAttributes_GetMaxy(self, NULL);
    if(strcmp(name, "minz") == 0)
        return BoxAttributes_GetMinz(self, NULL);
    if(strcmp(name, "maxz") == 0)
        return BoxAttributes_GetMaxz(self, NULL);

    return Py_FindMethod(BoxAttributes_methods, self, name);
}

static int
BoxAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "amount") == 0)
        retval = (BoxAttributes_SetAmount(self, tuple) != NULL);
    else if(strcmp(name, "minx") == 0)
        retval = (BoxAttributes_SetMinx(self, tuple) != NULL);
    else if(strcmp(name, "maxx") == 0)
        retval = (BoxAttributes_SetMaxx(self, tuple) != NULL);
    else if(strcmp(name, "miny") == 0)
        retval = (BoxAttributes_SetMiny(self, tuple) != NULL);
    else if(strcmp(name, "maxy") == 0)
        retval = (BoxAttributes_SetMaxy(self, tuple) != NULL);
    else if(strcmp(name, "minz") == 0)
        retval = (BoxAttributes_SetMinz(self, tuple) != NULL);
    else if(strcmp(name, "maxz") == 0)
        retval = (BoxAttributes_SetMaxz(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
BoxAttributes_print(PyObject *v, FILE *fp, int flags)
{
    BoxAttributesObject *obj = (BoxAttributesObject *)v;

    if(obj->data->GetAmount() == BoxAttributes::Some)
        fprintf(fp, "amount = Some\n");
    else
        fprintf(fp, "amount = All\n");

    fprintf(fp, "minx = %g\n", obj->data->GetMinx());
    fprintf(fp, "maxx = %g\n", obj->data->GetMaxx());
    fprintf(fp, "miny = %g\n", obj->data->GetMiny());
    fprintf(fp, "maxy = %g\n", obj->data->GetMaxy());
    fprintf(fp, "minz = %g\n", obj->data->GetMinz());
    fprintf(fp, "maxz = %g\n", obj->data->GetMaxz());

    return 0;
}

//
// The doc string for the class.
//
static char *BoxAttributes_Purpose = "This class contains attributes for the box operator.";

//
// The type description structure
//
static PyTypeObject BoxAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "BoxAttributes",                    // tp_name
    sizeof(BoxAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)BoxAttributes_dealloc,  // tp_dealloc
    (printfunc)BoxAttributes_print,     // tp_print
    (getattrfunc)BoxAttributes_getattr, // tp_getattr
    (setattrfunc)BoxAttributes_setattr, // tp_setattr
    (cmpfunc)BoxAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    BoxAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static BoxAttributes *defaultAtts = 0;

static PyObject *
NewBoxAttributes()
{
    BoxAttributesObject *newObject;
    newObject = PyObject_NEW(BoxAttributesObject, &BoxAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new BoxAttributes(*defaultAtts);
    else
        newObject->data = new BoxAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapBoxAttributes(const BoxAttributes *attr)
{
    BoxAttributesObject *newObject;
    newObject = PyObject_NEW(BoxAttributesObject, &BoxAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (BoxAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
BoxAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewBoxAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef BoxAttributesMethods[] = {
    {"BoxAttributes", BoxAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *BoxAttributesObserver = 0;
static bool BoxAttributesEnableLogging = true;

static void
PyBoxAttributes_WriteLog(Subject *subj, void *data)
{
    BoxAttributes *atts = (BoxAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!BoxAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# BoxAttributes_WriteLog()\n");
}

void
PyBoxAttributes_StartUp(BoxAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyBoxAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(BoxAttributesObserver == 0)
    {
        BoxAttributesObserver = new ObserverToCallback(subj,
            PyBoxAttributes_WriteLog, (void *)logFile);
    }

    BoxAttributesEnableLogging = true;
}

void
PyBoxAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete BoxAttributesObserver;
    BoxAttributesObserver = 0;
}

PyMethodDef *
PyBoxAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return BoxAttributesMethods;
}

bool
PyBoxAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &BoxAttributesType);
}

BoxAttributes *
PyBoxAttributes_FromPyObject(PyObject *obj)
{
    BoxAttributesObject *obj2 = (BoxAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyBoxAttributes_NewPyObject()
{
    return NewBoxAttributes();
}

PyObject *
PyBoxAttributes_WrapPyObject(const BoxAttributes *attr)
{
    return WrapBoxAttributes(attr);
}

void
PyBoxAttributes_SetLogging(bool val)
{
    BoxAttributesEnableLogging = val;
}

void
PyBoxAttributes_SetDefaults(const BoxAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new BoxAttributes(*atts);
}

