// ************************************************************************* //
//  File: BoxViewerPluginInfo.C
// ************************************************************************* //

#include <BoxPluginInfo.h>
#include <BoxAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Box_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Box operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    BoxViewerPluginInfo::InitializeGlobalObjects();
    return new BoxViewerPluginInfo;
}

//
// Storage for static data elements.
//
BoxAttributes *BoxViewerPluginInfo::clientAtts = NULL;
BoxAttributes *BoxViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  BoxViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************
void
BoxViewerPluginInfo::InitializeGlobalObjects()
{
    BoxViewerPluginInfo::clientAtts  = new BoxAttributes;
    BoxViewerPluginInfo::defaultAtts = new BoxAttributes;
}

// ****************************************************************************
//  Method: BoxViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************

AttributeSubject *
BoxViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: BoxViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************

AttributeSubject *
BoxViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: BoxViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************

void
BoxViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(BoxAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: BoxViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************

void
BoxViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(BoxAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: BoxViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************

void
BoxViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(BoxAttributes*)atts = *defaultAtts;
    else
        *(BoxAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: BoxViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 15:59:05 PST 2003
//
// ****************************************************************************

#include <Box.xpm>
const char **
BoxViewerPluginInfo::XPMIconData() const
{
    return Box_xpm;
}
