// ************************************************************************* //
//                        BoxScriptingPluginInfo.C
// ************************************************************************* //
#include <BoxPluginInfo.h>
#include <PyBoxAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Box_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Box plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:43 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new BoxScriptingPluginInfo;
}

// ****************************************************************************
// Method: BoxScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:43 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
BoxScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyBoxAttributes_StartUp((BoxAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: BoxScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:43 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
BoxScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyBoxAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: BoxScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Box plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:43 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
BoxScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyBoxAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: BoxScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:43 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
BoxScriptingPluginInfo::SetLogging(bool val)
{
    PyBoxAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: BoxScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:43 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
BoxScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyBoxAttributes_SetDefaults((const BoxAttributes *)atts);
}
