// ************************************************************************* //
//  File: BoxGUIPluginInfo.C
// ************************************************************************* //

#include <BoxPluginInfo.h>
#include <BoxAttributes.h>
#include <QvisBoxWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Box_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Box operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:11:53 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new BoxGUIPluginInfo;
}

// ****************************************************************************
//  Method: BoxGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:11:53 PST 2003
//
// ****************************************************************************

const char *
BoxGUIPluginInfo::GetMenuName() const
{
    return "Box";
}


// ****************************************************************************
//  Method: BoxGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:11:53 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
BoxGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisBoxWindow(type, (BoxAttributes *)attr,
        "Box operator attributes", "Box operator", notepad);
}

// ****************************************************************************
//  Method: BoxGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:11:53 PST 2003
//
// ****************************************************************************

#include <Box.xpm>
const char **
BoxGUIPluginInfo::XPMIconData() const
{
    return Box_xpm;
}
