#include <BoxAttributes.h>
#include <DataNode.h>
#include <BoxExtents.h>

//
// Enum conversion methods for BoxAttributes::Amount
//

static const char *Amount_strings[] = {
"Some", "All"};

std::string
BoxAttributes::Amount_ToString(BoxAttributes::Amount t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Amount_strings[index];
}

std::string
BoxAttributes::Amount_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Amount_strings[index];
}

bool
BoxAttributes::Amount_FromString(const std::string &s, BoxAttributes::Amount &val)
{
    val = BoxAttributes::Some;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Amount_strings[i])
        {
            val = (Amount)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: BoxAttributes::BoxAttributes
//
// Purpose: 
//   Constructor for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

BoxAttributes::BoxAttributes() : AttributeSubject("idddddd")
{
    amount = Some;
    minx = 0;
    maxx = 1;
    miny = 0;
    maxy = 1;
    minz = 0;
    maxz = 1;
}

// ****************************************************************************
// Method: BoxAttributes::BoxAttributes
//
// Purpose: 
//   Copy constructor for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

BoxAttributes::BoxAttributes(const BoxAttributes &obj) : AttributeSubject("idddddd")
{
    amount = obj.amount;
    minx = obj.minx;
    maxx = obj.maxx;
    miny = obj.miny;
    maxy = obj.maxy;
    minz = obj.minz;
    maxz = obj.maxz;

    SelectAll();
}

// ****************************************************************************
// Method: BoxAttributes::~BoxAttributes
//
// Purpose: 
//   Destructor for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

BoxAttributes::~BoxAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: BoxAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
BoxAttributes::operator = (const BoxAttributes &obj)
{
    amount = obj.amount;
    minx = obj.minx;
    maxx = obj.maxx;
    miny = obj.miny;
    maxy = obj.maxy;
    minz = obj.minz;
    maxz = obj.maxz;

    SelectAll();
}

// ****************************************************************************
// Method: BoxAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
BoxAttributes::operator == (const BoxAttributes &obj) const
{
    // Create the return value
    return ((amount == obj.amount) &&
            (minx == obj.minx) &&
            (maxx == obj.maxx) &&
            (miny == obj.miny) &&
            (maxy == obj.maxy) &&
            (minz == obj.minz) &&
            (maxz == obj.maxz));
}

// ****************************************************************************
// Method: BoxAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
BoxAttributes::operator != (const BoxAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: BoxAttributes::TypeName
//
// Purpose: 
//   Type name method for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
BoxAttributes::TypeName() const
{
    return "BoxAttributes";
}

// ****************************************************************************
// Method: BoxAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the BoxAttributes class.
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct 29 08:57:18 PDT 2002
//
// Modifications:
//
// ****************************************************************************

bool
BoxAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const BoxAttributes *tmp = (const BoxAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "BoxExtents")
    {
        const BoxExtents *tmp = (const BoxExtents *)atts;
        const double *extents = tmp->GetExtents();
        SetMinx(extents[0]);
        SetMaxx(extents[1]);
        SetMiny(extents[2]);
        SetMaxy(extents[3]);
        SetMinz(extents[4]);
        SetMaxz(extents[5]);
        retval = true;
    }

    return retval;
}

// ****************************************************************************
// Method: BoxAttributes::CreateCompatible
//
// Purpose: 
//   Creates an object of the specified type initialized with the attributes
//   from this object.
//
// Arguments:
//   tname : The typename of the object that we want to create.
//
// Returns:    A new object of the type specified by tname or 0.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct 29 08:57:46 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
BoxAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new BoxAttributes(*this);
    }
    else if(tname == "BoxExtents")
    {
        BoxExtents *b = new BoxExtents;
        double extents[6];
        extents[0] = minx;
        extents[1] = maxx;
        extents[2] = miny;
        extents[3] = maxy;
        extents[4] = minz;
        extents[5] = maxz;
        b->SetExtents(extents);

        retval = b;
    }

    return retval;
}

// ****************************************************************************
// Method: BoxAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the BoxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
BoxAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new BoxAttributes(*this);
    else
        retval = new BoxAttributes;

    return retval;
}

// ****************************************************************************
// Method: BoxAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
BoxAttributes::SelectAll()
{
    Select(0, (void *)&amount);
    Select(1, (void *)&minx);
    Select(2, (void *)&maxx);
    Select(3, (void *)&miny);
    Select(4, (void *)&maxy);
    Select(5, (void *)&minz);
    Select(6, (void *)&maxz);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoxAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
BoxAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    BoxAttributes defaultObject;
    bool addToParent = false;
    // Create a node for BoxAttributes.
    DataNode *node = new DataNode("BoxAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("amount", Amount_ToString(amount)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minx", minx));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxx", maxx));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("miny", miny));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxy", maxy));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minz", minz));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxz", maxz));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: BoxAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
BoxAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("BoxAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("amount")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetAmount(Amount(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Amount value;
            if(Amount_FromString(node->AsString(), value))
                SetAmount(value);
        }
    }
    if((node = searchNode->GetNode("minx")) != 0)
        SetMinx(node->AsDouble());
    if((node = searchNode->GetNode("maxx")) != 0)
        SetMaxx(node->AsDouble());
    if((node = searchNode->GetNode("miny")) != 0)
        SetMiny(node->AsDouble());
    if((node = searchNode->GetNode("maxy")) != 0)
        SetMaxy(node->AsDouble());
    if((node = searchNode->GetNode("minz")) != 0)
        SetMinz(node->AsDouble());
    if((node = searchNode->GetNode("maxz")) != 0)
        SetMaxz(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
BoxAttributes::SetAmount(BoxAttributes::Amount amount_)
{
    amount = amount_;
    Select(0, (void *)&amount);
}

void
BoxAttributes::SetMinx(double minx_)
{
    minx = minx_;
    Select(1, (void *)&minx);
}

void
BoxAttributes::SetMaxx(double maxx_)
{
    maxx = maxx_;
    Select(2, (void *)&maxx);
}

void
BoxAttributes::SetMiny(double miny_)
{
    miny = miny_;
    Select(3, (void *)&miny);
}

void
BoxAttributes::SetMaxy(double maxy_)
{
    maxy = maxy_;
    Select(4, (void *)&maxy);
}

void
BoxAttributes::SetMinz(double minz_)
{
    minz = minz_;
    Select(5, (void *)&minz);
}

void
BoxAttributes::SetMaxz(double maxz_)
{
    maxz = maxz_;
    Select(6, (void *)&maxz);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

BoxAttributes::Amount
BoxAttributes::GetAmount() const
{
    return Amount(amount);
}

double
BoxAttributes::GetMinx() const
{
    return minx;
}

double
BoxAttributes::GetMaxx() const
{
    return maxx;
}

double
BoxAttributes::GetMiny() const
{
    return miny;
}

double
BoxAttributes::GetMaxy() const
{
    return maxy;
}

double
BoxAttributes::GetMinz() const
{
    return minz;
}

double
BoxAttributes::GetMaxz() const
{
    return maxz;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoxAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
BoxAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Amount of cell in the range";
        case 1:  return "X-Minimum";
        case 2:  return "X-Maximum";
        case 3:  return "Y-Minimum";
        case 4:  return "Y-Maximum";
        case 5:  return "Z-Minimum";
        case 6:  return "Z-Maximum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoxAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
BoxAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_double;
        case 2:  return FieldType_double;
        case 3:  return FieldType_double;
        case 4:  return FieldType_double;
        case 5:  return FieldType_double;
        case 6:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: BoxAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
BoxAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "double";
        case 2:  return "double";
        case 3:  return "double";
        case 4:  return "double";
        case 5:  return "double";
        case 6:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoxAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
BoxAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const BoxAttributes &obj = *((const BoxAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (amount == obj.amount);
        }
        break;
    case 1:
        {  // new scope
        retval = (minx == obj.minx);
        }
        break;
    case 2:
        {  // new scope
        retval = (maxx == obj.maxx);
        }
        break;
    case 3:
        {  // new scope
        retval = (miny == obj.miny);
        }
        break;
    case 4:
        {  // new scope
        retval = (maxy == obj.maxy);
        }
        break;
    case 5:
        {  // new scope
        retval = (minz == obj.minz);
        }
        break;
    case 6:
        {  // new scope
        retval = (maxz == obj.maxz);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

