#ifndef _GET_PLUGIN_ERRORS_RPC_H_
#define _GET_PLUGIN_ERRORS_RPC_H_
#include <mdsrpc_exports.h>

#include <VisItRPC.h>
#include <string>

// *******************************************************************
// Class: GetPluginErrorsRPC
//
// Purpose:
//   Return the list of errors generated by plugin initialization.
//
// Programmer: Jeremy Meredith
// Creation:   February  7, 2005
//
// Modifications:
//
// *******************************************************************

class MDSERVER_RPC_API GetPluginErrorsRPC : public BlockingRPC
{
public:
    struct MDSERVER_RPC_API PluginErrors : public AttributeSubject
    {
        std::string errorString;
    public:
        PluginErrors();
        ~PluginErrors();
        virtual void SelectAll();
        virtual const std::string TypeName() const
            { return "GetPluginErrorsRPC::PluginErrors"; };
    };
public:
    GetPluginErrorsRPC();
    virtual ~GetPluginErrorsRPC();

    // Invokation method
    std::string operator()();

    // Property selection methods
    virtual void SelectAll();
private:
    PluginErrors errors;
};


#endif
