package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: VisualCueList
//
// Purpose:
//    container object for shipping vectors of visual cues
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Tue Jun 8 20:10:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

public class VisualCueList extends AttributeSubject
{
    public VisualCueList()
    {
        super(1);

        cues = new Vector();
    }

    public VisualCueList(VisualCueList obj)
    {
        super(1);

        int i;

        // *** Copy the cues field ***
        cues = new Vector(obj.cues.size());
        for(i = 0; i < obj.cues.size(); ++i)
        {
            VisualCueInfo newObj = (VisualCueInfo)cues.elementAt(i);
            cues.addElement(new VisualCueInfo(newObj));
        }


        SelectAll();
    }

    public boolean equals(VisualCueList obj)
    {
        int i;

        boolean cues_equal = (obj.cues.size() == cues.size());
        for(i = 0; (i < cues.size()) && cues_equal; ++i)
        {
            // Make references to VisualCueInfo from Object.
            VisualCueInfo cues1 = (VisualCueInfo)cues.elementAt(i);
            VisualCueInfo cues2 = (VisualCueInfo)obj.cues.elementAt(i);
            cues_equal = cues1.equals(cues2);
        }

        // Create the return value
        return (cues_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetCues() { return cues; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(cues.size());
            for(int i = 0; i < cues.size(); ++i)
            {
                VisualCueInfo tmp = (VisualCueInfo)cues.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        {
            int len = buf.ReadInt();
            cues.clear();
            for(int j = 0; j < len; ++j)
            {
                VisualCueInfo tmp = new VisualCueInfo();
                tmp.Read(buf);
                cues.addElement(tmp);
            }
        }
        Select(0);
    }

    // Attributegroup convenience methods
    public void AddVisualCueInfo(VisualCueInfo obj)
    {
        cues.addElement(new VisualCueInfo(obj));
        Select(0);
    }

    public void ClearVisualCueInfos()
    {
        cues.clear();
        Select(0);
    }

    public void RemoveVisualCueInfo(int index)
    {
        if(index >= 0 && index < cues.size())
        {
            cues.remove(index);
            Select(0);
        }
    }

    public int GetNumVisualCueInfos()
    {
        return cues.size();
    }

    public VisualCueInfo GetVisualCueInfo(int i)
    {
        VisualCueInfo tmp = (VisualCueInfo)cues.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector cues; // vector of VisualCueInfo objects
}

