package llnl.visit;


// ****************************************************************************
// Class: View2DAttributes
//
// Purpose:
//    This class contains the 2d view attributes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Oct 16 15:23:46 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class View2DAttributes extends AttributeSubject
{
    public View2DAttributes()
    {
        super(3);

        windowCoords = new double[4];
        windowCoords[0] = 0;
        windowCoords[1] = 0;
        windowCoords[2] = 1;
        windowCoords[3] = 1;
        viewportCoords = new double[4];
        viewportCoords[0] = 0.1;
        viewportCoords[1] = 0.1;
        viewportCoords[2] = 0.9;
        viewportCoords[3] = 0.9;
        fullFrame = false;
    }

    public View2DAttributes(View2DAttributes obj)
    {
        super(3);

        int i;

        windowCoords = new double[4];
        for(i = 0; i < obj.windowCoords.length; ++i)
            windowCoords[i] = obj.windowCoords[i];

        viewportCoords = new double[4];
        for(i = 0; i < obj.viewportCoords.length; ++i)
            viewportCoords[i] = obj.viewportCoords[i];

        fullFrame = obj.fullFrame;

        SelectAll();
    }

    public boolean equals(View2DAttributes obj)
    {
        int i;

        // Compare the windowCoords arrays.
        boolean windowCoords_equal = true;
        for(i = 0; i < 4 && windowCoords_equal; ++i)
            windowCoords_equal = (windowCoords[i] == obj.windowCoords[i]);

        // Compare the viewportCoords arrays.
        boolean viewportCoords_equal = true;
        for(i = 0; i < 4 && viewportCoords_equal; ++i)
            viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

        // Create the return value
        return (windowCoords_equal &&
                viewportCoords_equal &&
                (fullFrame == obj.fullFrame));
    }

    // Property setting methods
    public void SetWindowCoords(double[] windowCoords_)
    {
        windowCoords[0] = windowCoords_[0];
        windowCoords[1] = windowCoords_[1];
        windowCoords[2] = windowCoords_[2];
        windowCoords[3] = windowCoords_[3];
        Select(0);
    }

    public void SetWindowCoords(double e0, double e1, double e2, double e3)
    {
        windowCoords[0] = e0;
        windowCoords[1] = e1;
        windowCoords[2] = e2;
        windowCoords[3] = e3;
        Select(0);
    }

    public void SetViewportCoords(double[] viewportCoords_)
    {
        viewportCoords[0] = viewportCoords_[0];
        viewportCoords[1] = viewportCoords_[1];
        viewportCoords[2] = viewportCoords_[2];
        viewportCoords[3] = viewportCoords_[3];
        Select(1);
    }

    public void SetViewportCoords(double e0, double e1, double e2, double e3)
    {
        viewportCoords[0] = e0;
        viewportCoords[1] = e1;
        viewportCoords[2] = e2;
        viewportCoords[3] = e3;
        Select(1);
    }

    public void SetFullFrame(boolean fullFrame_)
    {
        fullFrame = fullFrame_;
        Select(2);
    }

    // Property getting methods
    public double[] GetWindowCoords() { return windowCoords; }
    public double[] GetViewportCoords() { return viewportCoords; }
    public boolean  GetFullFrame() { return fullFrame; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDoubleArray(windowCoords);
        if(WriteSelect(1, buf))
            buf.WriteDoubleArray(viewportCoords);
        if(WriteSelect(2, buf))
            buf.WriteBool(fullFrame);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetWindowCoords(buf.ReadDoubleArray());
                break;
            case 1:
                SetViewportCoords(buf.ReadDoubleArray());
                break;
            case 2:
                SetFullFrame(buf.ReadBool());
                break;
            }
        }
    }


    // Attributes
    private double[] windowCoords;
    private double[] viewportCoords;
    private boolean  fullFrame;
}

