#include <stdio.h>
#include <visit-config.h>

// ****************************************************************************
// Function: main
//
// Purpose:
//   Writes out a Java class that contains VisIt's version number. The class
//   is autogenerated so we don't have to keep doing it by hand.
//
// Notes:      
//
// Programmer: Brad Whitlock
// Creation:   Wed Aug 21 12:24:23 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

int
main(int argc, char *argv[])
{
    FILE *fp = NULL;
    const char *ver = VERSION;
    int i, reached_end = 0, retval = 1;

    // Open the file and write the Java class.
    if((fp = fopen("Version.java", "wb")) != NULL)
    {
        printf("Writing Version.java\n");
        fprintf(fp, "package llnl.visit;\n");
        fprintf(fp, "\n");
        fprintf(fp, "// ****************************************************************************\n");
        fprintf(fp, "// Class: Version\n");
        fprintf(fp, "//\n");
        fprintf(fp, "// Purpose:\n");
        fprintf(fp, "//   This automatically generated class contains VisIt's version.\n");
        fprintf(fp, "//\n");
        fprintf(fp, "// ****************************************************************************\n");
        fprintf(fp, "\n");
        fprintf(fp, "public class Version\n");
        fprintf(fp, "{\n");
        fprintf(fp, "    public final static byte[] version = {");

        // Print the characters of the version string.
        for(i = 0; i < 10; ++i)
        {
            if(reached_end)
                fprintf(fp, "'\\0'");
            else if(ver[i] == '\0')
            {
                reached_end = 1;
                fprintf(fp, "'\\0'");
            }
            else
                fprintf(fp, "'%c'", ver[i]);

            if(i < 9)
                fprintf(fp, ", ");
        }

        fprintf(fp, "};\n");
        fprintf(fp, "}\n");
        fprintf(fp, "\n");
        fclose(fp);
        retval = 0;
    }

    return retval;
}
