package llnl.visit;

import java.lang.Byte;
import java.util.Vector;

// ****************************************************************************
// Class: SILRestrictionAttributes
//
// Purpose:
//    The class contains attributes for SIL restrictions.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:23 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class SILRestrictionAttributes extends AttributeSubject
{
    public SILRestrictionAttributes()
    {
        super(3);

        useSet = new Vector();
        topSet = -1;
        silAtts = new SILAttributes();
    }

    public SILRestrictionAttributes(SILRestrictionAttributes obj)
    {
        super(3);

        int i;

        useSet = new Vector(obj.useSet.size());
        for(i = 0; i < obj.useSet.size(); ++i)
        {
            Byte bv = (Byte)obj.useSet.elementAt(i);
            useSet.addElement(new Byte(bv.byteValue()));
        }

        topSet = obj.topSet;
        silAtts = new SILAttributes(obj.silAtts);

        SelectAll();
    }

    public boolean equals(SILRestrictionAttributes obj)
    {
        int i;

        // Create the return value
        return ((useSet == obj.useSet) &&
                (topSet == obj.topSet) &&
                (silAtts == obj.silAtts));
    }

    // Property setting methods
    public void SetUseSet(Vector useSet_)
    {
        useSet = useSet_;
        Select(0);
    }

    public void SetTopSet(int topSet_)
    {
        topSet = topSet_;
        Select(1);
    }

    public void SetSilAtts(SILAttributes silAtts_)
    {
        silAtts = silAtts_;
        Select(2);
    }

    // Property getting methods
    public Vector        GetUseSet() { return useSet; }
    public int           GetTopSet() { return topSet; }
    public SILAttributes GetSilAtts() { return silAtts; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteByteVector(useSet);
        if(WriteSelect(1, buf))
            buf.WriteInt(topSet);
        if(WriteSelect(2, buf))
            silAtts.Write(buf);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetUseSet(buf.ReadByteVector());
                break;
            case 1:
                SetTopSet(buf.ReadInt());
                break;
            case 2:
                silAtts.Read(buf);
                Select(2);
                break;
            }
        }
    }


    // Attributes
    private Vector        useSet; // vector of Byte objects
    private int           topSet;
    private SILAttributes silAtts;
}

