package llnl.visit;


// ****************************************************************************
// Class: RenderingAttributes
//
// Purpose:
//    This class contains special rendering attributes like antialiasing and stero settings.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Fri Jan 7 17:06:47 PST 2005
//
// Modifications:
//   
// ****************************************************************************

public class RenderingAttributes extends AttributeSubject
{
    // Enum values
    public final static int GEOMETRYREPRESENTATION_SURFACES = 0;
    public final static int GEOMETRYREPRESENTATION_WIREFRAME = 1;
    public final static int GEOMETRYREPRESENTATION_POINTS = 2;

    public final static int STEREOTYPES_REDBLUE = 0;
    public final static int STEREOTYPES_INTERLACED = 1;
    public final static int STEREOTYPES_CRYSTALEYES = 2;

    public final static int TRISTATEMODE_NEVER = 0;
    public final static int TRISTATEMODE_ALWAYS = 1;
    public final static int TRISTATEMODE_AUTO = 2;

    // Constants
    public final static int DEFAULT_SCALABLE_AUTO_THRESHOLD = 2000000;

    public final static int DEFAULT_SCALABLE_ACTIVATION_MODE = TRISTATEMODE_AUTO;


    public RenderingAttributes()
    {
        super(14);

        antialiasing = false;
        geometryRepresentation = GEOMETRYREPRESENTATION_SURFACES;
        displayListMode = TRISTATEMODE_AUTO;
        stereoRendering = false;
        stereoType = STEREOTYPES_CRYSTALEYES;
        notifyForEachRender = false;
        scalableActivationMode = TRISTATEMODE_AUTO;
        scalableAutoThreshold = 2000000;
        specularFlag = false;
        specularCoeff = 0.6f;
        specularPower = 10f;
        specularColor = new ColorAttribute(255, 255, 255);
        doShadowing = false;
        shadowStrength = 0.5;
    }

    public RenderingAttributes(RenderingAttributes obj)
    {
        super(14);

        antialiasing = obj.antialiasing;
        geometryRepresentation = obj.geometryRepresentation;
        displayListMode = obj.displayListMode;
        stereoRendering = obj.stereoRendering;
        stereoType = obj.stereoType;
        notifyForEachRender = obj.notifyForEachRender;
        scalableActivationMode = obj.scalableActivationMode;
        scalableAutoThreshold = obj.scalableAutoThreshold;
        specularFlag = obj.specularFlag;
        specularCoeff = obj.specularCoeff;
        specularPower = obj.specularPower;
        specularColor = new ColorAttribute(obj.specularColor);
        doShadowing = obj.doShadowing;
        shadowStrength = obj.shadowStrength;

        SelectAll();
    }

    public boolean equals(RenderingAttributes obj)
    {
        // Create the return value
        return ((antialiasing == obj.antialiasing) &&
                (geometryRepresentation == obj.geometryRepresentation) &&
                (displayListMode == obj.displayListMode) &&
                (stereoRendering == obj.stereoRendering) &&
                (stereoType == obj.stereoType) &&
                (notifyForEachRender == obj.notifyForEachRender) &&
                (scalableActivationMode == obj.scalableActivationMode) &&
                (scalableAutoThreshold == obj.scalableAutoThreshold) &&
                (specularFlag == obj.specularFlag) &&
                (specularCoeff == obj.specularCoeff) &&
                (specularPower == obj.specularPower) &&
                (specularColor == obj.specularColor) &&
                (doShadowing == obj.doShadowing) &&
                (shadowStrength == obj.shadowStrength));
    }

    // Property setting methods
    public void SetAntialiasing(boolean antialiasing_)
    {
        antialiasing = antialiasing_;
        Select(0);
    }

    public void SetGeometryRepresentation(int geometryRepresentation_)
    {
        geometryRepresentation = geometryRepresentation_;
        Select(1);
    }

    public void SetDisplayListMode(int displayListMode_)
    {
        displayListMode = displayListMode_;
        Select(2);
    }

    public void SetStereoRendering(boolean stereoRendering_)
    {
        stereoRendering = stereoRendering_;
        Select(3);
    }

    public void SetStereoType(int stereoType_)
    {
        stereoType = stereoType_;
        Select(4);
    }

    public void SetNotifyForEachRender(boolean notifyForEachRender_)
    {
        notifyForEachRender = notifyForEachRender_;
        Select(5);
    }

    public void SetScalableActivationMode(int scalableActivationMode_)
    {
        scalableActivationMode = scalableActivationMode_;
        Select(6);
    }

    public void SetScalableAutoThreshold(int scalableAutoThreshold_)
    {
        scalableAutoThreshold = scalableAutoThreshold_;
        Select(7);
    }

    public void SetSpecularFlag(boolean specularFlag_)
    {
        specularFlag = specularFlag_;
        Select(8);
    }

    public void SetSpecularCoeff(float specularCoeff_)
    {
        specularCoeff = specularCoeff_;
        Select(9);
    }

    public void SetSpecularPower(float specularPower_)
    {
        specularPower = specularPower_;
        Select(10);
    }

    public void SetSpecularColor(ColorAttribute specularColor_)
    {
        specularColor = specularColor_;
        Select(11);
    }

    public void SetDoShadowing(boolean doShadowing_)
    {
        doShadowing = doShadowing_;
        Select(12);
    }

    public void SetShadowStrength(double shadowStrength_)
    {
        shadowStrength = shadowStrength_;
        Select(13);
    }

    // Property getting methods
    public boolean        GetAntialiasing() { return antialiasing; }
    public int            GetGeometryRepresentation() { return geometryRepresentation; }
    public int            GetDisplayListMode() { return displayListMode; }
    public boolean        GetStereoRendering() { return stereoRendering; }
    public int            GetStereoType() { return stereoType; }
    public boolean        GetNotifyForEachRender() { return notifyForEachRender; }
    public int            GetScalableActivationMode() { return scalableActivationMode; }
    public int            GetScalableAutoThreshold() { return scalableAutoThreshold; }
    public boolean        GetSpecularFlag() { return specularFlag; }
    public float          GetSpecularCoeff() { return specularCoeff; }
    public float          GetSpecularPower() { return specularPower; }
    public ColorAttribute GetSpecularColor() { return specularColor; }
    public boolean        GetDoShadowing() { return doShadowing; }
    public double         GetShadowStrength() { return shadowStrength; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(antialiasing);
        if(WriteSelect(1, buf))
            buf.WriteInt(geometryRepresentation);
        if(WriteSelect(2, buf))
            buf.WriteInt(displayListMode);
        if(WriteSelect(3, buf))
            buf.WriteBool(stereoRendering);
        if(WriteSelect(4, buf))
            buf.WriteInt(stereoType);
        if(WriteSelect(5, buf))
            buf.WriteBool(notifyForEachRender);
        if(WriteSelect(6, buf))
            buf.WriteInt(scalableActivationMode);
        if(WriteSelect(7, buf))
            buf.WriteInt(scalableAutoThreshold);
        if(WriteSelect(8, buf))
            buf.WriteBool(specularFlag);
        if(WriteSelect(9, buf))
            buf.WriteFloat(specularCoeff);
        if(WriteSelect(10, buf))
            buf.WriteFloat(specularPower);
        if(WriteSelect(11, buf))
            specularColor.Write(buf);
        if(WriteSelect(12, buf))
            buf.WriteBool(doShadowing);
        if(WriteSelect(13, buf))
            buf.WriteDouble(shadowStrength);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetAntialiasing(buf.ReadBool());
                break;
            case 1:
                SetGeometryRepresentation(buf.ReadInt());
                break;
            case 2:
                SetDisplayListMode(buf.ReadInt());
                break;
            case 3:
                SetStereoRendering(buf.ReadBool());
                break;
            case 4:
                SetStereoType(buf.ReadInt());
                break;
            case 5:
                SetNotifyForEachRender(buf.ReadBool());
                break;
            case 6:
                SetScalableActivationMode(buf.ReadInt());
                break;
            case 7:
                SetScalableAutoThreshold(buf.ReadInt());
                break;
            case 8:
                SetSpecularFlag(buf.ReadBool());
                break;
            case 9:
                SetSpecularCoeff(buf.ReadFloat());
                break;
            case 10:
                SetSpecularPower(buf.ReadFloat());
                break;
            case 11:
                specularColor.Read(buf);
                Select(11);
                break;
            case 12:
                SetDoShadowing(buf.ReadBool());
                break;
            case 13:
                SetShadowStrength(buf.ReadDouble());
                break;
            }
        }
    }


    // Attributes
    private boolean        antialiasing;
    private int            geometryRepresentation;
    private int            displayListMode;
    private boolean        stereoRendering;
    private int            stereoType;
    private boolean        notifyForEachRender;
    private int            scalableActivationMode;
    private int            scalableAutoThreshold;
    private boolean        specularFlag;
    private float          specularCoeff;
    private float          specularPower;
    private ColorAttribute specularColor;
    private boolean        doShadowing;
    private double         shadowStrength;
}

