package llnl.visit;


// ****************************************************************************
// Class: QueryOverTimeAttributes
//
// Purpose:
//    Attributes for queries over time.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Fri Apr 2 10:59:09 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

public class QueryOverTimeAttributes extends AttributeSubject
{
    // Constants
    public final static int TIMETYPE_CYCLE = 0;
    public final static int TIMETYPE_DTIME = 1;
    public final static int TIMETYPE_TIMESTEP = 2;


    public QueryOverTimeAttributes()
    {
        super(9);

        timeType = TIMETYPE_CYCLE;
        startTimeFlag = false;
        startTime = 0;
        endTimeFlag = false;
        endTime = 1;
        stride = 1;
        createWindow = true;
        windowId = 2;
        queryAtts = new QueryAttributes();
    }

    public QueryOverTimeAttributes(QueryOverTimeAttributes obj)
    {
        super(9);

        timeType = obj.timeType;
        startTimeFlag = obj.startTimeFlag;
        startTime = obj.startTime;
        endTimeFlag = obj.endTimeFlag;
        endTime = obj.endTime;
        stride = obj.stride;
        createWindow = obj.createWindow;
        windowId = obj.windowId;
        queryAtts = new QueryAttributes(obj.queryAtts);

        SelectAll();
    }

    public boolean equals(QueryOverTimeAttributes obj)
    {
        // Create the return value
        return ((timeType == obj.timeType) &&
                (startTimeFlag == obj.startTimeFlag) &&
                (startTime == obj.startTime) &&
                (endTimeFlag == obj.endTimeFlag) &&
                (endTime == obj.endTime) &&
                (stride == obj.stride) &&
                (createWindow == obj.createWindow) &&
                (windowId == obj.windowId) &&
                (queryAtts == obj.queryAtts));
    }

    // Property setting methods
    public void SetTimeType(int timeType_)
    {
        timeType = timeType_;
        Select(0);
    }

    public void SetStartTimeFlag(boolean startTimeFlag_)
    {
        startTimeFlag = startTimeFlag_;
        Select(1);
    }

    public void SetStartTime(int startTime_)
    {
        startTime = startTime_;
        Select(2);
    }

    public void SetEndTimeFlag(boolean endTimeFlag_)
    {
        endTimeFlag = endTimeFlag_;
        Select(3);
    }

    public void SetEndTime(int endTime_)
    {
        endTime = endTime_;
        Select(4);
    }

    public void SetStride(int stride_)
    {
        stride = stride_;
        Select(5);
    }

    public void SetCreateWindow(boolean createWindow_)
    {
        createWindow = createWindow_;
        Select(6);
    }

    public void SetWindowId(int windowId_)
    {
        windowId = windowId_;
        Select(7);
    }

    public void SetQueryAtts(QueryAttributes queryAtts_)
    {
        queryAtts = queryAtts_;
        Select(8);
    }

    // Property getting methods
    public int             GetTimeType() { return timeType; }
    public boolean         GetStartTimeFlag() { return startTimeFlag; }
    public int             GetStartTime() { return startTime; }
    public boolean         GetEndTimeFlag() { return endTimeFlag; }
    public int             GetEndTime() { return endTime; }
    public int             GetStride() { return stride; }
    public boolean         GetCreateWindow() { return createWindow; }
    public int             GetWindowId() { return windowId; }
    public QueryAttributes GetQueryAtts() { return queryAtts; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(timeType);
        if(WriteSelect(1, buf))
            buf.WriteBool(startTimeFlag);
        if(WriteSelect(2, buf))
            buf.WriteInt(startTime);
        if(WriteSelect(3, buf))
            buf.WriteBool(endTimeFlag);
        if(WriteSelect(4, buf))
            buf.WriteInt(endTime);
        if(WriteSelect(5, buf))
            buf.WriteInt(stride);
        if(WriteSelect(6, buf))
            buf.WriteBool(createWindow);
        if(WriteSelect(7, buf))
            buf.WriteInt(windowId);
        if(WriteSelect(8, buf))
            queryAtts.Write(buf);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetTimeType(buf.ReadInt());
                break;
            case 1:
                SetStartTimeFlag(buf.ReadBool());
                break;
            case 2:
                SetStartTime(buf.ReadInt());
                break;
            case 3:
                SetEndTimeFlag(buf.ReadBool());
                break;
            case 4:
                SetEndTime(buf.ReadInt());
                break;
            case 5:
                SetStride(buf.ReadInt());
                break;
            case 6:
                SetCreateWindow(buf.ReadBool());
                break;
            case 7:
                SetWindowId(buf.ReadInt());
                break;
            case 8:
                queryAtts.Read(buf);
                Select(8);
                break;
            }
        }
    }


    // Attributes
    private int             timeType;
    private boolean         startTimeFlag;
    private int             startTime;
    private boolean         endTimeFlag;
    private int             endTime;
    private int             stride;
    private boolean         createWindow;
    private int             windowId;
    private QueryAttributes queryAtts;
}

