package llnl.visit;

import java.util.Vector;
import java.lang.Integer;

// ****************************************************************************
// Class: QueryList
//
// Purpose:
//    List of supported queries
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Wed Dec 15 17:03:38 PST 2004
//
// Modifications:
//   
// ****************************************************************************

public class QueryList extends AttributeSubject
{
    // Enum values
    public final static int QUERYTYPE_DATABASEQUERY = 0;
    public final static int QUERYTYPE_POINTQUERY = 1;
    public final static int QUERYTYPE_LINEQUERY = 2;

    public final static int WINDOWTYPE_BASIC = 0;
    public final static int WINDOWTYPE_SINGLEPOINT = 1;
    public final static int WINDOWTYPE_DOUBLEPOINT = 2;
    public final static int WINDOWTYPE_DOMAINNODE = 3;
    public final static int WINDOWTYPE_DOMAINNODEVARS = 4;
    public final static int WINDOWTYPE_DOMAINZONE = 5;
    public final static int WINDOWTYPE_DOMAINZONEVARS = 6;
    public final static int WINDOWTYPE_ACTUALDATA = 7;
    public final static int WINDOWTYPE_ACTUALDATAVARS = 8;

    public final static int GROUPS_CURVERELATED = 0;
    public final static int GROUPS_MESHRELATED = 1;
    public final static int GROUPS_PICKRELATED = 2;
    public final static int GROUPS_TIMERELATED = 3;
    public final static int GROUPS_VARIABLERELATED = 4;


    public QueryList()
    {
        super(7);

        names = new Vector();
        types = new Vector();
        groups = new Vector();
        numInputs = new Vector();
        allowedVarTypes = new Vector();
        winType = new Vector();
        timeQuery = new Vector();
    }

    public QueryList(QueryList obj)
    {
        super(7);

        int i;

        names = new Vector(obj.names.size());
        for(i = 0; i < obj.names.size(); ++i)
            names.addElement(new String((String)obj.names.elementAt(i)));

        types = new Vector();
        for(i = 0; i < obj.types.size(); ++i)
        {
            Integer iv = (Integer)obj.types.elementAt(i);
            types.addElement(new Integer(iv.intValue()));
        }
        groups = new Vector();
        for(i = 0; i < obj.groups.size(); ++i)
        {
            Integer iv = (Integer)obj.groups.elementAt(i);
            groups.addElement(new Integer(iv.intValue()));
        }
        numInputs = new Vector();
        for(i = 0; i < obj.numInputs.size(); ++i)
        {
            Integer iv = (Integer)obj.numInputs.elementAt(i);
            numInputs.addElement(new Integer(iv.intValue()));
        }
        allowedVarTypes = new Vector();
        for(i = 0; i < obj.allowedVarTypes.size(); ++i)
        {
            Integer iv = (Integer)obj.allowedVarTypes.elementAt(i);
            allowedVarTypes.addElement(new Integer(iv.intValue()));
        }
        winType = new Vector();
        for(i = 0; i < obj.winType.size(); ++i)
        {
            Integer iv = (Integer)obj.winType.elementAt(i);
            winType.addElement(new Integer(iv.intValue()));
        }
        timeQuery = new Vector();
        for(i = 0; i < obj.timeQuery.size(); ++i)
        {
            Integer iv = (Integer)obj.timeQuery.elementAt(i);
            timeQuery.addElement(new Integer(iv.intValue()));
        }

        SelectAll();
    }

    public boolean equals(QueryList obj)
    {
        int i;

        // Create the return value
        return ((names == obj.names) &&
                (types == obj.types) &&
                (groups == obj.groups) &&
                (numInputs == obj.numInputs) &&
                (allowedVarTypes == obj.allowedVarTypes) &&
                (winType == obj.winType) &&
                (timeQuery == obj.timeQuery));
    }

    // Property setting methods
    public void SetNames(Vector names_)
    {
        names = names_;
        Select(0);
    }

    public void SetTypes(Vector types_)
    {
        types = types_;
        Select(1);
    }

    public void SetGroups(Vector groups_)
    {
        groups = groups_;
        Select(2);
    }

    public void SetNumInputs(Vector numInputs_)
    {
        numInputs = numInputs_;
        Select(3);
    }

    public void SetAllowedVarTypes(Vector allowedVarTypes_)
    {
        allowedVarTypes = allowedVarTypes_;
        Select(4);
    }

    public void SetWinType(Vector winType_)
    {
        winType = winType_;
        Select(5);
    }

    public void SetTimeQuery(Vector timeQuery_)
    {
        timeQuery = timeQuery_;
        Select(6);
    }

    // Property getting methods
    public Vector GetNames() { return names; }
    public Vector GetTypes() { return types; }
    public Vector GetGroups() { return groups; }
    public Vector GetNumInputs() { return numInputs; }
    public Vector GetAllowedVarTypes() { return allowedVarTypes; }
    public Vector GetWinType() { return winType; }
    public Vector GetTimeQuery() { return timeQuery; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteStringVector(names);
        if(WriteSelect(1, buf))
            buf.WriteIntVector(types);
        if(WriteSelect(2, buf))
            buf.WriteIntVector(groups);
        if(WriteSelect(3, buf))
            buf.WriteIntVector(numInputs);
        if(WriteSelect(4, buf))
            buf.WriteIntVector(allowedVarTypes);
        if(WriteSelect(5, buf))
            buf.WriteIntVector(winType);
        if(WriteSelect(6, buf))
            buf.WriteIntVector(timeQuery);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetNames(buf.ReadStringVector());
                break;
            case 1:
                SetTypes(buf.ReadIntVector());
                break;
            case 2:
                SetGroups(buf.ReadIntVector());
                break;
            case 3:
                SetNumInputs(buf.ReadIntVector());
                break;
            case 4:
                SetAllowedVarTypes(buf.ReadIntVector());
                break;
            case 5:
                SetWinType(buf.ReadIntVector());
                break;
            case 6:
                SetTimeQuery(buf.ReadIntVector());
                break;
            }
        }
    }


    // Attributes
    private Vector names; // vector of String objects
    private Vector types; // vector of Integer objects
    private Vector groups; // vector of Integer objects
    private Vector numInputs; // vector of Integer objects
    private Vector allowedVarTypes; // vector of Integer objects
    private Vector winType; // vector of Integer objects
    private Vector timeQuery; // vector of Integer objects
}

