package llnl.visit;

import java.util.Vector;
import java.lang.Integer;

// ****************************************************************************
// Class: PluginManagerAttributes
//
// Purpose:
//    This class contains attributes for managing plugins.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:20 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class PluginManagerAttributes extends AttributeSubject
{
    public PluginManagerAttributes()
    {
        super(5);

        name = new Vector();
        type = new Vector();
        version = new Vector();
        id = new Vector();
        enabled = new Vector();
    }

    public PluginManagerAttributes(PluginManagerAttributes obj)
    {
        super(5);

        int i;

        name = new Vector(obj.name.size());
        for(i = 0; i < obj.name.size(); ++i)
            name.addElement(new String((String)obj.name.elementAt(i)));

        type = new Vector(obj.type.size());
        for(i = 0; i < obj.type.size(); ++i)
            type.addElement(new String((String)obj.type.elementAt(i)));

        version = new Vector(obj.version.size());
        for(i = 0; i < obj.version.size(); ++i)
            version.addElement(new String((String)obj.version.elementAt(i)));

        id = new Vector(obj.id.size());
        for(i = 0; i < obj.id.size(); ++i)
            id.addElement(new String((String)obj.id.elementAt(i)));

        enabled = new Vector();
        for(i = 0; i < obj.enabled.size(); ++i)
        {
            Integer iv = (Integer)obj.enabled.elementAt(i);
            enabled.addElement(new Integer(iv.intValue()));
        }

        SelectAll();
    }

    public boolean equals(PluginManagerAttributes obj)
    {
        int i;

        // Create the return value
        return ((name == obj.name) &&
                (type == obj.type) &&
                (version == obj.version) &&
                (id == obj.id) &&
                (enabled == obj.enabled));
    }

    // Property setting methods
    public void SetName(Vector name_)
    {
        name = name_;
        Select(0);
    }

    public void SetType(Vector type_)
    {
        type = type_;
        Select(1);
    }

    public void SetVersion(Vector version_)
    {
        version = version_;
        Select(2);
    }

    public void SetId(Vector id_)
    {
        id = id_;
        Select(3);
    }

    public void SetEnabled(Vector enabled_)
    {
        enabled = enabled_;
        Select(4);
    }

    // Property getting methods
    public Vector GetName() { return name; }
    public Vector GetType() { return type; }
    public Vector GetVersion() { return version; }
    public Vector GetId() { return id; }
    public Vector GetEnabled() { return enabled; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteStringVector(name);
        if(WriteSelect(1, buf))
            buf.WriteStringVector(type);
        if(WriteSelect(2, buf))
            buf.WriteStringVector(version);
        if(WriteSelect(3, buf))
            buf.WriteStringVector(id);
        if(WriteSelect(4, buf))
            buf.WriteIntVector(enabled);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetName(buf.ReadStringVector());
                break;
            case 1:
                SetType(buf.ReadStringVector());
                break;
            case 2:
                SetVersion(buf.ReadStringVector());
                break;
            case 3:
                SetId(buf.ReadStringVector());
                break;
            case 4:
                SetEnabled(buf.ReadIntVector());
                break;
            }
        }
    }


    // Attributes
    private Vector name; // vector of String objects
    private Vector type; // vector of String objects
    private Vector version; // vector of String objects
    private Vector id; // vector of String objects
    private Vector enabled; // vector of Integer objects
}

