package llnl.visit;

import java.lang.Integer;
import java.util.Vector;

// ****************************************************************************
// Class: Plot
//
// Purpose:
//    This class is a plot element in a plot list.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Tue Mar 30 17:34:18 PST 2004
//
// Modifications:
//   
// ****************************************************************************

public class Plot extends AttributeSubject
{
    // Constants
    public final static int STATETYPE_NEWLYCREATED = 0;
    public final static int STATETYPE_PENDING = 1;
    public final static int STATETYPE_COMPLETED = 2;
    public final static int STATETYPE_ERROR = 3;


    public Plot()
    {
        super(15);

        stateType = STATETYPE_NEWLYCREATED;
        plotType = 0;
        activeFlag = false;
        hiddenFlag = false;
        expandedFlag = false;
        plotVar = new String("notset");
        databaseName = new String("notset");
        operators = new Vector();
        activeOperator = -1;
        id = -1;
        beginFrame = -999;
        endFrame = 999;
        keyframes = new Vector();
        databaseKeyframes = new Vector();
        isFromSimulation = false;
    }

    public Plot(Plot obj)
    {
        super(15);

        int i;

        stateType = obj.stateType;
        plotType = obj.plotType;
        activeFlag = obj.activeFlag;
        hiddenFlag = obj.hiddenFlag;
        expandedFlag = obj.expandedFlag;
        plotVar = new String(obj.plotVar);
        databaseName = new String(obj.databaseName);
        operators = new Vector();
        for(i = 0; i < obj.operators.size(); ++i)
        {
            Integer iv = (Integer)obj.operators.elementAt(i);
            operators.addElement(new Integer(iv.intValue()));
        }
        activeOperator = obj.activeOperator;
        id = obj.id;
        beginFrame = obj.beginFrame;
        endFrame = obj.endFrame;
        keyframes = new Vector();
        for(i = 0; i < obj.keyframes.size(); ++i)
        {
            Integer iv = (Integer)obj.keyframes.elementAt(i);
            keyframes.addElement(new Integer(iv.intValue()));
        }
        databaseKeyframes = new Vector();
        for(i = 0; i < obj.databaseKeyframes.size(); ++i)
        {
            Integer iv = (Integer)obj.databaseKeyframes.elementAt(i);
            databaseKeyframes.addElement(new Integer(iv.intValue()));
        }
        isFromSimulation = obj.isFromSimulation;

        SelectAll();
    }

    public boolean equals(Plot obj)
    {
        int i;

        // Create the return value
        return ((stateType == obj.stateType) &&
                (plotType == obj.plotType) &&
                (activeFlag == obj.activeFlag) &&
                (hiddenFlag == obj.hiddenFlag) &&
                (expandedFlag == obj.expandedFlag) &&
                (plotVar == obj.plotVar) &&
                (databaseName == obj.databaseName) &&
                (operators == obj.operators) &&
                (activeOperator == obj.activeOperator) &&
                (id == obj.id) &&
                (beginFrame == obj.beginFrame) &&
                (endFrame == obj.endFrame) &&
                (keyframes == obj.keyframes) &&
                (databaseKeyframes == obj.databaseKeyframes) &&
                (isFromSimulation == obj.isFromSimulation));
    }

    // Property setting methods
    public void SetStateType(int stateType_)
    {
        stateType = stateType_;
        Select(0);
    }

    public void SetPlotType(int plotType_)
    {
        plotType = plotType_;
        Select(1);
    }

    public void SetActiveFlag(boolean activeFlag_)
    {
        activeFlag = activeFlag_;
        Select(2);
    }

    public void SetHiddenFlag(boolean hiddenFlag_)
    {
        hiddenFlag = hiddenFlag_;
        Select(3);
    }

    public void SetExpandedFlag(boolean expandedFlag_)
    {
        expandedFlag = expandedFlag_;
        Select(4);
    }

    public void SetPlotVar(String plotVar_)
    {
        plotVar = plotVar_;
        Select(5);
    }

    public void SetDatabaseName(String databaseName_)
    {
        databaseName = databaseName_;
        Select(6);
    }

    public void SetOperators(Vector operators_)
    {
        operators = operators_;
        Select(7);
    }

    public void SetActiveOperator(int activeOperator_)
    {
        activeOperator = activeOperator_;
        Select(8);
    }

    public void SetId(int id_)
    {
        id = id_;
        Select(9);
    }

    public void SetBeginFrame(int beginFrame_)
    {
        beginFrame = beginFrame_;
        Select(10);
    }

    public void SetEndFrame(int endFrame_)
    {
        endFrame = endFrame_;
        Select(11);
    }

    public void SetKeyframes(Vector keyframes_)
    {
        keyframes = keyframes_;
        Select(12);
    }

    public void SetDatabaseKeyframes(Vector databaseKeyframes_)
    {
        databaseKeyframes = databaseKeyframes_;
        Select(13);
    }

    public void SetIsFromSimulation(boolean isFromSimulation_)
    {
        isFromSimulation = isFromSimulation_;
        Select(14);
    }

    // Property getting methods
    public int     GetStateType() { return stateType; }
    public int     GetPlotType() { return plotType; }
    public boolean GetActiveFlag() { return activeFlag; }
    public boolean GetHiddenFlag() { return hiddenFlag; }
    public boolean GetExpandedFlag() { return expandedFlag; }
    public String  GetPlotVar() { return plotVar; }
    public String  GetDatabaseName() { return databaseName; }
    public Vector  GetOperators() { return operators; }
    public int     GetActiveOperator() { return activeOperator; }
    public int     GetId() { return id; }
    public int     GetBeginFrame() { return beginFrame; }
    public int     GetEndFrame() { return endFrame; }
    public Vector  GetKeyframes() { return keyframes; }
    public Vector  GetDatabaseKeyframes() { return databaseKeyframes; }
    public boolean GetIsFromSimulation() { return isFromSimulation; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(stateType);
        if(WriteSelect(1, buf))
            buf.WriteInt(plotType);
        if(WriteSelect(2, buf))
            buf.WriteBool(activeFlag);
        if(WriteSelect(3, buf))
            buf.WriteBool(hiddenFlag);
        if(WriteSelect(4, buf))
            buf.WriteBool(expandedFlag);
        if(WriteSelect(5, buf))
            buf.WriteString(plotVar);
        if(WriteSelect(6, buf))
            buf.WriteString(databaseName);
        if(WriteSelect(7, buf))
            buf.WriteIntVector(operators);
        if(WriteSelect(8, buf))
            buf.WriteInt(activeOperator);
        if(WriteSelect(9, buf))
            buf.WriteInt(id);
        if(WriteSelect(10, buf))
            buf.WriteInt(beginFrame);
        if(WriteSelect(11, buf))
            buf.WriteInt(endFrame);
        if(WriteSelect(12, buf))
            buf.WriteIntVector(keyframes);
        if(WriteSelect(13, buf))
            buf.WriteIntVector(databaseKeyframes);
        if(WriteSelect(14, buf))
            buf.WriteBool(isFromSimulation);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetStateType(buf.ReadInt());
                break;
            case 1:
                SetPlotType(buf.ReadInt());
                break;
            case 2:
                SetActiveFlag(buf.ReadBool());
                break;
            case 3:
                SetHiddenFlag(buf.ReadBool());
                break;
            case 4:
                SetExpandedFlag(buf.ReadBool());
                break;
            case 5:
                SetPlotVar(buf.ReadString());
                break;
            case 6:
                SetDatabaseName(buf.ReadString());
                break;
            case 7:
                SetOperators(buf.ReadIntVector());
                break;
            case 8:
                SetActiveOperator(buf.ReadInt());
                break;
            case 9:
                SetId(buf.ReadInt());
                break;
            case 10:
                SetBeginFrame(buf.ReadInt());
                break;
            case 11:
                SetEndFrame(buf.ReadInt());
                break;
            case 12:
                SetKeyframes(buf.ReadIntVector());
                break;
            case 13:
                SetDatabaseKeyframes(buf.ReadIntVector());
                break;
            case 14:
                SetIsFromSimulation(buf.ReadBool());
                break;
            }
        }
    }


    // Attributes
    private int     stateType;
    private int     plotType;
    private boolean activeFlag;
    private boolean hiddenFlag;
    private boolean expandedFlag;
    private String  plotVar;
    private String  databaseName;
    private Vector  operators; // vector of Integer objects
    private int     activeOperator;
    private int     id;
    private int     beginFrame;
    private int     endFrame;
    private Vector  keyframes; // vector of Integer objects
    private Vector  databaseKeyframes; // vector of Integer objects
    private boolean isFromSimulation;
}

