package llnl.visit;

import java.lang.Integer;
import java.util.Vector;

// ****************************************************************************
// Class: NamespaceAttributes
//
// Purpose:
//    This class contain the information needed to represent a namespace.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:18 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class NamespaceAttributes extends AttributeSubject
{
    public NamespaceAttributes()
    {
        super(4);

        type = -1;
        subsets = new Vector();
        min = -1;
        max = -1;
    }

    public NamespaceAttributes(NamespaceAttributes obj)
    {
        super(4);

        int i;

        type = obj.type;
        subsets = new Vector();
        for(i = 0; i < obj.subsets.size(); ++i)
        {
            Integer iv = (Integer)obj.subsets.elementAt(i);
            subsets.addElement(new Integer(iv.intValue()));
        }
        min = obj.min;
        max = obj.max;

        SelectAll();
    }

    public boolean equals(NamespaceAttributes obj)
    {
        int i;

        // Create the return value
        return ((type == obj.type) &&
                (subsets == obj.subsets) &&
                (min == obj.min) &&
                (max == obj.max));
    }

    // Property setting methods
    public void SetType(int type_)
    {
        type = type_;
        Select(0);
    }

    public void SetSubsets(Vector subsets_)
    {
        subsets = subsets_;
        Select(1);
    }

    public void SetMin(int min_)
    {
        min = min_;
        Select(2);
    }

    public void SetMax(int max_)
    {
        max = max_;
        Select(3);
    }

    // Property getting methods
    public int    GetType() { return type; }
    public Vector GetSubsets() { return subsets; }
    public int    GetMin() { return min; }
    public int    GetMax() { return max; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(type);
        if(WriteSelect(1, buf))
            buf.WriteIntVector(subsets);
        if(WriteSelect(2, buf))
            buf.WriteInt(min);
        if(WriteSelect(3, buf))
            buf.WriteInt(max);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetType(buf.ReadInt());
                break;
            case 1:
                SetSubsets(buf.ReadIntVector());
                break;
            case 2:
                SetMin(buf.ReadInt());
                break;
            case 3:
                SetMax(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private int    type;
    private Vector subsets; // vector of Integer objects
    private int    min;
    private int    max;
}

