package llnl.visit;


// ****************************************************************************
// Class: MessageAttributes
//
// Purpose:
//    This class contains attributes for sending messages.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:18 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class MessageAttributes extends AttributeSubject
{
    // Constants
    public final static int SEVERITY_ERROR = 0;
    public final static int SEVERITY_WARNING = 1;
    public final static int SEVERITY_MESSAGE = 2;


    public MessageAttributes()
    {
        super(2);

        text = new String("");
        severity = SEVERITY_MESSAGE;
    }

    public MessageAttributes(MessageAttributes obj)
    {
        super(2);

        text = new String(obj.text);
        severity = obj.severity;

        SelectAll();
    }

    public boolean equals(MessageAttributes obj)
    {
        // Create the return value
        return ((text == obj.text) &&
                (severity == obj.severity));
    }

    // Property setting methods
    public void SetText(String text_)
    {
        text = text_;
        Select(0);
    }

    public void SetSeverity(int severity_)
    {
        severity = severity_;
        Select(1);
    }

    // Property getting methods
    public String GetText() { return text; }
    public int    GetSeverity() { return severity; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(text);
        if(WriteSelect(1, buf))
            buf.WriteInt(severity);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetText(buf.ReadString());
                break;
            case 1:
                SetSeverity(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private String text;
    private int    severity;
}

