package llnl.visit;


// ****************************************************************************
// Class: LightAttributes
//
// Purpose:
//    This class is a light in a light list.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:16 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class LightAttributes extends AttributeSubject
{
    // Constants
    public final static int LIGHTTYPE_AMBIENT = 0;
    public final static int LIGHTTYPE_OBJECT = 1;
    public final static int LIGHTTYPE_CAMERA = 2;


    public LightAttributes()
    {
        super(5);

        enabledFlag = false;
        type = LIGHTTYPE_CAMERA;
        direction = new double[3];
        direction[0] = 0;
        direction[1] = 0;
        direction[2] = -1;
        color = new ColorAttribute(255, 255, 255);
        brightness = 1;
    }

    public LightAttributes(LightAttributes obj)
    {
        super(5);

        int i;

        enabledFlag = obj.enabledFlag;
        type = obj.type;
        direction = new double[3];
        direction[0] = obj.direction[0];
        direction[1] = obj.direction[1];
        direction[2] = obj.direction[2];

        color = new ColorAttribute(obj.color);
        brightness = obj.brightness;

        SelectAll();
    }

    public boolean equals(LightAttributes obj)
    {
        int i;

        // Compare the direction arrays.
        boolean direction_equal = true;
        for(i = 0; i < 3 && direction_equal; ++i)
            direction_equal = (direction[i] == obj.direction[i]);

        // Create the return value
        return ((enabledFlag == obj.enabledFlag) &&
                (type == obj.type) &&
                direction_equal &&
                (color == obj.color) &&
                (brightness == obj.brightness));
    }

    // Property setting methods
    public void SetEnabledFlag(boolean enabledFlag_)
    {
        enabledFlag = enabledFlag_;
        Select(0);
    }

    public void SetType(int type_)
    {
        type = type_;
        Select(1);
    }

    public void SetDirection(double[] direction_)
    {
        direction[0] = direction_[0];
        direction[1] = direction_[1];
        direction[2] = direction_[2];
        Select(2);
    }

    public void SetDirection(double e0, double e1, double e2)
    {
        direction[0] = e0;
        direction[1] = e1;
        direction[2] = e2;
        Select(2);
    }

    public void SetColor(ColorAttribute color_)
    {
        color = color_;
        Select(3);
    }

    public void SetBrightness(double brightness_)
    {
        brightness = brightness_;
        Select(4);
    }

    // Property getting methods
    public boolean        GetEnabledFlag() { return enabledFlag; }
    public int            GetType() { return type; }
    public double[]       GetDirection() { return direction; }
    public ColorAttribute GetColor() { return color; }
    public double         GetBrightness() { return brightness; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(enabledFlag);
        if(WriteSelect(1, buf))
            buf.WriteInt(type);
        if(WriteSelect(2, buf))
            buf.WriteDoubleArray(direction);
        if(WriteSelect(3, buf))
            color.Write(buf);
        if(WriteSelect(4, buf))
            buf.WriteDouble(brightness);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetEnabledFlag(buf.ReadBool());
                break;
            case 1:
                SetType(buf.ReadInt());
                break;
            case 2:
                SetDirection(buf.ReadDoubleArray());
                break;
            case 3:
                color.Read(buf);
                Select(3);
                break;
            case 4:
                SetBrightness(buf.ReadDouble());
                break;
            }
        }
    }


    // Attributes
    private boolean        enabledFlag;
    private int            type;
    private double[]       direction;
    private ColorAttribute color;
    private double         brightness;
}

