package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: HostProfileList
//
// Purpose:
//    This class contains a list of host profiles.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:16 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class HostProfileList extends AttributeSubject
{
    public HostProfileList()
    {
        super(2);

        profiles = new Vector();
        activeProfile = -1;
    }

    public HostProfileList(HostProfileList obj)
    {
        super(2);

        int i;

        // *** Copy the profiles field ***
        profiles = new Vector(obj.profiles.size());
        for(i = 0; i < obj.profiles.size(); ++i)
        {
            HostProfile newObj = (HostProfile)profiles.elementAt(i);
            profiles.addElement(new HostProfile(newObj));
        }

        activeProfile = obj.activeProfile;

        SelectAll();
    }

    public boolean equals(HostProfileList obj)
    {
        int i;

        boolean profiles_equal = (obj.profiles.size() == profiles.size());
        for(i = 0; (i < profiles.size()) && profiles_equal; ++i)
        {
            // Make references to HostProfile from Object.
            HostProfile profiles1 = (HostProfile)profiles.elementAt(i);
            HostProfile profiles2 = (HostProfile)obj.profiles.elementAt(i);
            profiles_equal = profiles1.equals(profiles2);
        }

        // Create the return value
        return (profiles_equal &&
                (activeProfile == obj.activeProfile));
    }

    // Property setting methods
    public void SetActiveProfile(int activeProfile_)
    {
        activeProfile = activeProfile_;
        Select(1);
    }

    // Property getting methods
    public Vector GetProfiles() { return profiles; }
    public int    GetActiveProfile() { return activeProfile; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(profiles.size());
            for(int i = 0; i < profiles.size(); ++i)
            {
                HostProfile tmp = (HostProfile)profiles.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(1, buf))
            buf.WriteInt(activeProfile);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                {
                    int len = buf.ReadInt();
                    profiles.clear();
                    for(int j = 0; j < len; ++j)
                    {
                        HostProfile tmp = new HostProfile();
                        tmp.Read(buf);
                        profiles.addElement(tmp);
                    }
                }
                Select(0);
                break;
            case 1:
                SetActiveProfile(buf.ReadInt());
                break;
            }
        }
    }

    // Attributegroup convenience methods
    public void AddHostProfile(HostProfile obj)
    {
        profiles.addElement(new HostProfile(obj));
        Select(0);
    }

    public void ClearHostProfiles()
    {
        profiles.clear();
        Select(0);
    }

    public void RemoveHostProfile(int index)
    {
        if(index >= 0 && index < profiles.size())
        {
            profiles.remove(index);
            Select(0);
        }
    }

    public int GetNumHostProfiles()
    {
        return profiles.size();
    }

    public HostProfile GetHostProfile(int i)
    {
        HostProfile tmp = (HostProfile)profiles.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector profiles; // vector of HostProfile objects
    private int    activeProfile;
}

