package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: ExpressionList
//
// Purpose:
//    This class contains a list of expressions.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:14 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class ExpressionList extends AttributeSubject
{
    public ExpressionList()
    {
        super(1);

        expressions = new Vector();
    }

    public ExpressionList(ExpressionList obj)
    {
        super(1);

        int i;

        // *** Copy the expressions field ***
        expressions = new Vector(obj.expressions.size());
        for(i = 0; i < obj.expressions.size(); ++i)
        {
            Expression newObj = (Expression)expressions.elementAt(i);
            expressions.addElement(new Expression(newObj));
        }


        SelectAll();
    }

    public boolean equals(ExpressionList obj)
    {
        int i;

        boolean expressions_equal = (obj.expressions.size() == expressions.size());
        for(i = 0; (i < expressions.size()) && expressions_equal; ++i)
        {
            // Make references to Expression from Object.
            Expression expressions1 = (Expression)expressions.elementAt(i);
            Expression expressions2 = (Expression)obj.expressions.elementAt(i);
            expressions_equal = expressions1.equals(expressions2);
        }

        // Create the return value
        return (expressions_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetExpressions() { return expressions; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(expressions.size());
            for(int i = 0; i < expressions.size(); ++i)
            {
                Expression tmp = (Expression)expressions.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        {
            int len = buf.ReadInt();
            expressions.clear();
            for(int j = 0; j < len; ++j)
            {
                Expression tmp = new Expression();
                tmp.Read(buf);
                expressions.addElement(tmp);
            }
        }
        Select(0);
    }

    // Attributegroup convenience methods
    public void AddExpression(Expression obj)
    {
        expressions.addElement(new Expression(obj));
        Select(0);
    }

    public void ClearExpressions()
    {
        expressions.clear();
        Select(0);
    }

    public void RemoveExpression(int index)
    {
        if(index >= 0 && index < expressions.size())
        {
            expressions.remove(index);
            Select(0);
        }
    }

    public int GetNumExpressions()
    {
        return expressions.size();
    }

    public Expression GetExpression(int i)
    {
        Expression tmp = (Expression)expressions.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector expressions; // vector of Expression objects
}

