package llnl.visit;


// ****************************************************************************
// Class: Expression
//
// Purpose:
//    This class contains an expression.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:14 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class Expression extends AttributeSubject
{
    // Constants
    public final static int EXPRTYPE_UNKNOWN = 0;
    public final static int EXPRTYPE_SCALARMESHVAR = 1;
    public final static int EXPRTYPE_VECTORMESHVAR = 2;
    public final static int EXPRTYPE_MESH = 3;
    public final static int EXPRTYPE_MATERIAL = 4;
    public final static int EXPRTYPE_SPECIES = 5;


    public Expression()
    {
        super(4);

        name = new String("notset");
        definition = new String("notset");
        hidden = false;
        type = EXPRTYPE_SCALARMESHVAR;
    }

    public Expression(Expression obj)
    {
        super(4);

        name = new String(obj.name);
        definition = new String(obj.definition);
        hidden = obj.hidden;
        type = obj.type;

        SelectAll();
    }

    public boolean equals(Expression obj)
    {
        // Create the return value
        return ((name == obj.name) &&
                (definition == obj.definition) &&
                (hidden == obj.hidden) &&
                (type == obj.type));
    }

    // Property setting methods
    public void SetName(String name_)
    {
        name = name_;
        Select(0);
    }

    public void SetDefinition(String definition_)
    {
        definition = definition_;
        Select(1);
    }

    public void SetHidden(boolean hidden_)
    {
        hidden = hidden_;
        Select(2);
    }

    public void SetType(int type_)
    {
        type = type_;
        Select(3);
    }

    // Property getting methods
    public String  GetName() { return name; }
    public String  GetDefinition() { return definition; }
    public boolean GetHidden() { return hidden; }
    public int     GetType() { return type; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(name);
        if(WriteSelect(1, buf))
            buf.WriteString(definition);
        if(WriteSelect(2, buf))
            buf.WriteBool(hidden);
        if(WriteSelect(3, buf))
            buf.WriteInt(type);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetName(buf.ReadString());
                break;
            case 1:
                SetDefinition(buf.ReadString());
                break;
            case 2:
                SetHidden(buf.ReadBool());
                break;
            case 3:
                SetType(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private String  name;
    private String  definition;
    private boolean hidden;
    private int     type;
}

