package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: ColorTableAttributes
//
// Purpose:
//    This class contains the list of colortables.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Tue Dec 3 11:23:37 PDT 2002
//
// Modifications:
//   Brad Whitlock, Thu Dec 12 10:38:14 PDT 2002
//   This file has some methods that need to be added back in if the file is
//   ever regenerated.
//
// ****************************************************************************

public class ColorTableAttributes extends AttributeSubject
{
    public ColorTableAttributes()
    {
        super(4);

        names = new Vector();
        colorTables = new Vector();
        activeContinuous = new String("hot");
        activeDiscrete = new String("levels");
    }

    public ColorTableAttributes(ColorTableAttributes obj)
    {
        super(4);

        int i;

        names = new Vector(obj.names.size());
        for(i = 0; i < obj.names.size(); ++i)
            names.addElement(new String((String)obj.names.elementAt(i)));

        // *** Copy the colorTables field ***
        colorTables = new Vector(obj.colorTables.size());
        for(i = 0; i < obj.colorTables.size(); ++i)
        {
            ColorControlPointList newObj = (ColorControlPointList)colorTables.elementAt(i);
            colorTables.addElement(new ColorControlPointList(newObj));
        }

        activeContinuous = new String(obj.activeContinuous);
        activeDiscrete = new String(obj.activeDiscrete);

        SelectAll();
    }

    public boolean equals(ColorTableAttributes obj)
    {
        int i;

        boolean colorTables_equal = (obj.colorTables.size() == colorTables.size());
        for(i = 0; (i < colorTables.size()) && colorTables_equal; ++i)
        {
            // Make references to ColorControlPointList from Object.
            ColorControlPointList colorTables1 = (ColorControlPointList)colorTables.elementAt(i);
            ColorControlPointList colorTables2 = (ColorControlPointList)obj.colorTables.elementAt(i);
            colorTables_equal = colorTables1.equals(colorTables2);
        }

        // Create the return value
        return ((names == obj.names) &&
                colorTables_equal &&
                (activeContinuous == obj.activeContinuous) &&
                (activeDiscrete == obj.activeDiscrete));
    }

    // Property setting methods
    public void SetNames(Vector names_)
    {
        names = names_;
        Select(0);
    }

    public void SetActiveContinuous(String activeContinuous_)
    {
        activeContinuous = activeContinuous_;
        Select(2);
    }

    public void SetActiveDiscrete(String activeDiscrete_)
    {
        activeDiscrete = activeDiscrete_;
        Select(3);
    }

    // Property getting methods
    public Vector GetNames() { return names; }
    public Vector GetColorTables() { return colorTables; }
    public String GetActiveContinuous() { return activeContinuous; }
    public String GetActiveDiscrete() { return activeDiscrete; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteStringVector(names);
        if(WriteSelect(1, buf))
        {
            buf.WriteInt(colorTables.size());
            for(int i = 0; i < colorTables.size(); ++i)
            {
                ColorControlPointList tmp = (ColorControlPointList)colorTables.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(2, buf))
            buf.WriteString(activeContinuous);
        if(WriteSelect(3, buf))
            buf.WriteString(activeDiscrete);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetNames(buf.ReadStringVector());
                break;
            case 1:
                {
                    int len = buf.ReadInt();
                    colorTables.clear();
                    for(int j = 0; j < len; ++j)
                    {
                        ColorControlPointList tmp = new ColorControlPointList();
                        tmp.Read(buf);
                        colorTables.addElement(tmp);
                    }
                }
                Select(1);
                break;
            case 2:
                SetActiveContinuous(buf.ReadString());
                break;
            case 3:
                SetActiveDiscrete(buf.ReadString());
                break;
            }
        }
    }

    // Attributegroup convenience methods
    public void AddColorControlPointList(ColorControlPointList obj)
    {
        colorTables.addElement(new ColorControlPointList(obj));
        Select(1);
    }

    public void ClearColorControlPointLists()
    {
        colorTables.clear();
        Select(1);
    }

    public void RemoveColorControlPointList(int index)
    {
        if(index >= 0 && index < colorTables.size())
        {
            colorTables.remove(index);
            Select(1);
        }
    }

    public int GetNumColorControlPointLists()
    {
        return colorTables.size();
    }

    public ColorControlPointList GetColorControlPointList(int i)
    {
        ColorControlPointList tmp = (ColorControlPointList)colorTables.elementAt(i);
        return tmp;
    }

    // Added methods
    public int GetColorTableIndex(String name)
    {
        int retval = -1;
        for(int i = 0; i < names.size(); ++i)
        {
            String n = (String)names.elementAt(i);
            if(n.equals(name))
            {
                retval = i;
                break;
            }
        }

        return retval;
    }

    public ColorControlPointList GetColorControlPoints(int index)
    {
        if(index >= 0 && index < colorTables.size())
            return (ColorControlPointList)colorTables.elementAt(index);
        else
            return null;
    }

    public ColorControlPointList GetColorControlPoints(String name)
    {
        int index = GetColorTableIndex(name);
        if(index >= 0 && index < colorTables.size())
            return (ColorControlPointList)colorTables.elementAt(index);
        else
            return null;
    }

    public ColorControlPointList GetActiveColorControlPoints()
    {
        int index = GetColorTableIndex(activeContinuous);
        if(index >= 0 && index < colorTables.size())
            return (ColorControlPointList)colorTables.elementAt(index);
        else
            return null;
    }

    public void AddColorTable(String name, ColorControlPointList cpts)
    {
        names.addElement(new String(name));
        Select(0);
        AddColorControlPointList(cpts);
    }

    public void RemoveColorTable(String name)
    {
        int index = GetColorTableIndex(name);
        RemoveColorTable(index);
    }

    public void RemoveColorTable(int index)
    {
        if(index >= 0 && index < names.size())
        {
            String nameAt = (String)names.elementAt(index);
            boolean isActiveContinuous = nameAt.equals(activeContinuous);
            boolean isActiveDiscrete = nameAt.equals(activeDiscrete);

            // Remove the name from the vector.
            names.remove(index);
            Select(0);

            // Remove the color table from the vector.
            RemoveColorControlPointList(index);

            // If it is the active color table that was removed, reset the
            // active color table to the first element.
            if(isActiveContinuous)
            {
                if(names.size() > 0)
                {
                    nameAt = (String)names.elementAt(0);
                    SetActiveContinuous(nameAt);
                }
                else
                    SetActiveContinuous("");
            }
            if(isActiveDiscrete)
            {
                if(names.size() > 0)
                {
                    nameAt = (String)names.elementAt(0);
                    SetActiveDiscrete(nameAt);
                }
                else
                    SetActiveDiscrete("");
            }
        }
    }

    // Attributes
    private Vector names; // vector of String objects
    private Vector colorTables; // vector of ColorControlPointList objects
    private String activeContinuous;
    private String activeDiscrete;
}

